/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor8;

final class InjectProcessingStep
extends TypeCheckingProcessingStep<Element> {
    private final ElementVisitor<Void, Void> visitor;

    @Inject
    InjectProcessingStep(final InjectBindingRegistry injectBindingRegistry) {
        super((Element e) -> e);
        this.visitor = new ElementKindVisitor8<Void, Void>(){

            @Override
            public Void visitExecutableAsConstructor(ExecutableElement constructorElement, Void aVoid) {
                injectBindingRegistry.tryRegisterConstructor(constructorElement);
                return null;
            }

            @Override
            public Void visitVariableAsField(VariableElement fieldElement, Void aVoid) {
                injectBindingRegistry.tryRegisterMembersInjectedType(MoreElements.asType(fieldElement.getEnclosingElement()));
                return null;
            }

            @Override
            public Void visitExecutableAsMethod(ExecutableElement methodElement, Void aVoid) {
                injectBindingRegistry.tryRegisterMembersInjectedType(MoreElements.asType(methodElement.getEnclosingElement()));
                return null;
            }
        };
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Inject.class);
    }

    @Override
    protected void process(Element injectElement, ImmutableSet<Class<? extends Annotation>> annotations) {
        injectElement.accept(this.visitor, null);
    }
}

