/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.multibindings.Multibinds;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

class MultibindsMethodValidator
extends BindingMethodValidator {
    @Inject
    MultibindsMethodValidator(DaggerElements elements, DaggerTypes types, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(elements, types, Multibinds.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), dependencyRequestValidator, BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingElementValidator.AllowsMultibindings.NO_MULTIBINDINGS, BindingElementValidator.AllowsScoping.NO_SCOPING, injectionAnnotations);
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(ExecutableElement element) {
        return new Validator(element);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        Validator(ExecutableElement element) {
            super(MultibindsMethodValidator.this, element);
        }

        @Override
        protected void checkParameters() {
            if (!((ExecutableElement)this.element).getParameters().isEmpty()) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("cannot have parameters", new Object[0]));
            }
        }

        @Override
        protected void checkType() {
            if (!this.isPlainMap(((ExecutableElement)this.element).getReturnType()) && !this.isPlainSet(((ExecutableElement)this.element).getReturnType())) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("must return Map<K, V> or Set<T>", new Object[0]));
            }
        }

        private boolean isPlainMap(TypeMirror returnType) {
            if (!MapType.isMap(returnType)) {
                return false;
            }
            MapType mapType = MapType.from(returnType);
            return !mapType.isRawType() && MoreTypes.isType(mapType.valueType()) && !FrameworkTypes.isFrameworkType(mapType.valueType());
        }

        private boolean isPlainSet(TypeMirror returnType) {
            if (!SetType.isSet(returnType)) {
                return false;
            }
            SetType setType = SetType.from(returnType);
            return !setType.isRawType() && MoreTypes.isType(setType.elementType()) && !FrameworkTypes.isFrameworkType(setType.elementType());
        }
    }
}

