/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.compileroption.ValidationType;
import dagger.internal.codegen.validation.DiagnosticReporterFactory;
import dagger.internal.codegen.validation.Validation;
import dagger.model.BindingGraph;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@Singleton
public final class BindingGraphValidator {
    private final ImmutableSet<BindingGraphPlugin> validationPlugins;
    private final ImmutableSet<BindingGraphPlugin> externalPlugins;
    private final DiagnosticReporterFactory diagnosticReporterFactory;
    private final CompilerOptions compilerOptions;

    @Inject
    BindingGraphValidator(@Validation Set<BindingGraphPlugin> validationPlugins, ImmutableSet<BindingGraphPlugin> externalPlugins, DiagnosticReporterFactory diagnosticReporterFactory, CompilerOptions compilerOptions) {
        this.validationPlugins = ImmutableSet.copyOf(validationPlugins);
        this.externalPlugins = ImmutableSet.copyOf(externalPlugins);
        this.diagnosticReporterFactory = (DiagnosticReporterFactory)Preconditions.checkNotNull((Object)diagnosticReporterFactory);
        this.compilerOptions = compilerOptions;
    }

    public boolean shouldDoFullBindingGraphValidation(TypeElement component) {
        return this.requiresFullBindingGraphValidation() || this.compilerOptions.pluginsVisitFullBindingGraphs(component);
    }

    private boolean requiresFullBindingGraphValidation() {
        return !this.compilerOptions.fullBindingGraphValidationType().equals((Object)ValidationType.NONE);
    }

    public boolean isValid(BindingGraph graph) {
        return this.validate(graph) && this.visitPlugins(graph);
    }

    private boolean validate(BindingGraph graph) {
        if (graph.isFullBindingGraph() && !this.requiresFullBindingGraphValidation()) {
            return true;
        }
        boolean errorsAsWarnings = graph.isFullBindingGraph() && this.compilerOptions.fullBindingGraphValidationType().equals((Object)ValidationType.WARNING);
        return this.runPlugins(this.validationPlugins, graph, errorsAsWarnings);
    }

    private boolean visitPlugins(BindingGraph graph) {
        TypeElement component = graph.rootComponentNode().componentPath().currentComponent();
        if (graph.isFullBindingGraph() && !this.requiresFullBindingGraphValidation() && !this.compilerOptions.pluginsVisitFullBindingGraphs(component)) {
            return true;
        }
        return this.runPlugins(this.externalPlugins, graph, false);
    }

    private boolean runPlugins(ImmutableSet<BindingGraphPlugin> plugins, BindingGraph graph, boolean errorsAsWarnings) {
        boolean isClean = true;
        for (BindingGraphPlugin plugin : plugins) {
            DiagnosticReporterFactory.DiagnosticReporterImpl reporter = this.diagnosticReporterFactory.reporter(graph, plugin, errorsAsWarnings);
            plugin.visitGraph(graph, (DiagnosticReporter)reporter);
            if (!reporter.reportedDiagnosticKinds().contains((Object)Diagnostic.Kind.ERROR)) continue;
            isClean = false;
        }
        return isClean;
    }
}

