/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.SuperficialValidation;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public final class InjectionAnnotations {
    private final KotlinMetadataUtil kotlinMetadataUtil;

    @Inject
    InjectionAnnotations(KotlinMetadataUtil kotlinMetadataUtil) {
        this.kotlinMetadataUtil = kotlinMetadataUtil;
    }

    public Optional<AnnotationMirror> getQualifier(Element e) {
        if (!SuperficialValidation.validateElement(e)) {
            throw new TypeNotPresentException(e.toString(), null);
        }
        Preconditions.checkNotNull((Object)e);
        ImmutableSet<? extends AnnotationMirror> qualifierAnnotations = this.getQualifiers(e);
        switch (qualifierAnnotations.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((AnnotationMirror)qualifierAnnotations.iterator().next());
            }
        }
        throw new IllegalArgumentException(e + " was annotated with more than one @Qualifier annotation");
    }

    public ImmutableSet<? extends AnnotationMirror> getQualifiers(Element element) {
        ImmutableSet<? extends AnnotationMirror> qualifiers = AnnotationMirrors.getAnnotatedAnnotations(element, Qualifier.class);
        if (this.kotlinMetadataUtil.hasMetadata(element) && element.getKind() == ElementKind.FIELD) {
            return Sets.union(qualifiers, this.kotlinMetadataUtil.getSyntheticPropertyAnnotations(MoreElements.asVariable(element), Qualifier.class)).immutableCopy();
        }
        return qualifiers;
    }

    public static ImmutableSet<ExecutableElement> injectedConstructors(TypeElement type) {
        return FluentIterable.from(ElementFilter.constructorsIn(type.getEnclosedElements())).filter(constructor -> MoreElements.isAnnotationPresent(constructor, Inject.class)).toSet();
    }
}

