/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.Traverser;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.DaggerElements;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

final class DaggerTypes
implements Types {
    private final Types types;
    private final DaggerElements elements;
    private static final ImmutableSet<Class<?>> FUTURE_TYPES = ImmutableSet.of(ListenableFuture.class, FluentFuture.class);

    @Inject
    DaggerTypes(Types types, DaggerElements elements) {
        this.types = (Types)Preconditions.checkNotNull((Object)types);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
    }

    Optional<DeclaredType> nonObjectSuperclass(DeclaredType type) {
        return Optional.ofNullable((DeclaredType)MoreTypes.nonObjectSuperclass(this.types, this.elements, type).orNull());
    }

    Iterable<TypeMirror> supertypes(TypeMirror type) {
        return Traverser.forGraph(this::directSupertypes).breadthFirst((Object)type);
    }

    TypeMirror unwrapType(TypeMirror type) {
        TypeMirror unwrapped = this.unwrapTypeOrDefault(type, null);
        Preconditions.checkArgument((unwrapped != null ? 1 : 0) != 0, (String)"%s is a raw type", (Object)type);
        return unwrapped;
    }

    TypeMirror unwrapTypeOrObject(TypeMirror type) {
        return this.unwrapTypeOrDefault(type, this.elements.getTypeElement(Object.class).asType());
    }

    private TypeMirror unwrapTypeOrDefault(TypeMirror type, TypeMirror defaultType) {
        DeclaredType declaredType = MoreTypes.asDeclared(type);
        TypeElement typeElement = MoreElements.asType(declaredType.asElement());
        Preconditions.checkArgument((!typeElement.getTypeParameters().isEmpty() ? 1 : 0) != 0, (String)"%s does not have a type parameter", (Object)typeElement.getQualifiedName());
        return (TypeMirror)Iterables.getOnlyElement(declaredType.getTypeArguments(), (Object)defaultType);
    }

    DeclaredType wrapType(TypeMirror type, Class<?> wrappingClass) {
        return this.types.getDeclaredType(this.elements.getTypeElement(wrappingClass), type);
    }

    DeclaredType rewrapType(TypeMirror type, Class<?> wrappingClass) {
        List<? extends TypeMirror> typeArguments = MoreTypes.asDeclared(type).getTypeArguments();
        TypeElement wrappingType = this.elements.getTypeElement(wrappingClass);
        switch (typeArguments.size()) {
            case 0: {
                return this.getDeclaredType(wrappingType, new TypeMirror[0]);
            }
            case 1: {
                return this.getDeclaredType(wrappingType, (TypeMirror)Iterables.getOnlyElement(typeArguments));
            }
        }
        throw new IllegalArgumentException(type + " has more than 1 type argument");
    }

    protected TypeMirror publiclyAccessibleType(TypeMirror type) {
        return this.accessibleType(type, Accessibility::isTypePubliclyAccessible, Accessibility::isRawTypePubliclyAccessible);
    }

    protected TypeMirror accessibleType(TypeMirror type, ClassName requestingClass) {
        return this.accessibleType(type, t -> Accessibility.isTypeAccessibleFrom(t, requestingClass.packageName()), t -> Accessibility.isRawTypeAccessible(t, requestingClass.packageName()));
    }

    private TypeMirror accessibleType(TypeMirror type, Predicate<TypeMirror> accessibilityPredicate, Predicate<TypeMirror> rawTypeAccessibilityPredicate) {
        if (accessibilityPredicate.test(type)) {
            return type;
        }
        if (type.getKind().equals((Object)TypeKind.DECLARED) && rawTypeAccessibilityPredicate.test(type)) {
            return this.getDeclaredType(MoreTypes.asTypeElement(type), new TypeMirror[0]);
        }
        return this.elements.getTypeElement(Object.class).asType();
    }

    static void checkTypePresent(final TypeMirror type) {
        type.accept(new SimpleTypeVisitor8<Void, Void>(){

            @Override
            public Void visitArray(ArrayType arrayType, Void p) {
                return arrayType.getComponentType().accept(this, p);
            }

            @Override
            public Void visitDeclared(DeclaredType declaredType, Void p) {
                declaredType.getTypeArguments().forEach(t -> t.accept(this, p));
                return null;
            }

            @Override
            public Void visitError(ErrorType errorType, Void p) {
                throw new TypeNotPresentException(type.toString(), null);
            }
        }, null);
    }

    static boolean isFutureType(TypeMirror type) {
        return FUTURE_TYPES.stream().anyMatch(t -> MoreTypes.isTypeOf(t, type));
    }

    static boolean hasTypeVariable(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitArray(ArrayType arrayType, Void p) {
                return arrayType.getComponentType().accept(this, p);
            }

            @Override
            public Boolean visitDeclared(DeclaredType declaredType, Void p) {
                return declaredType.getTypeArguments().stream().anyMatch(type -> type.accept(this, p));
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable t, Void aVoid) {
                return true;
            }

            @Override
            protected Boolean defaultAction(TypeMirror e, Void aVoid) {
                return false;
            }
        }, null);
    }

    public ExecutableType resolveExecutableType(ExecutableElement element, TypeMirror containerType) {
        return MoreTypes.asExecutable(this.asMemberOf(MoreTypes.asDeclared(containerType), element));
    }

    @Override
    public Element asElement(TypeMirror t) {
        return this.types.asElement(t);
    }

    @Override
    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return this.types.isSameType(t1, t2);
    }

    @Override
    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        return this.types.isSubtype(t1, t2);
    }

    @Override
    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        return this.types.isAssignable(t1, t2);
    }

    @Override
    public boolean contains(TypeMirror t1, TypeMirror t2) {
        return this.types.contains(t1, t2);
    }

    @Override
    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return this.types.isSubsignature(m1, m2);
    }

    @Override
    public List<? extends TypeMirror> directSupertypes(TypeMirror t) {
        return this.types.directSupertypes(t);
    }

    @Override
    public TypeMirror erasure(TypeMirror t) {
        return this.types.erasure(t);
    }

    @Override
    public TypeElement boxedClass(PrimitiveType p) {
        return this.types.boxedClass(p);
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror t) {
        return this.types.unboxedType(t);
    }

    @Override
    public TypeMirror capture(TypeMirror t) {
        return this.types.capture(t);
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind kind) {
        return this.types.getPrimitiveType(kind);
    }

    @Override
    public NullType getNullType() {
        return this.types.getNullType();
    }

    @Override
    public NoType getNoType(TypeKind kind) {
        return this.types.getNoType(kind);
    }

    @Override
    public ArrayType getArrayType(TypeMirror componentType) {
        return this.types.getArrayType(componentType);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        return this.types.getWildcardType(extendsBound, superBound);
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.types.getDeclaredType(typeElem, typeArgs);
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.types.getDeclaredType(containing, typeElem, typeArgs);
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        return this.types.asMemberOf(containing, element);
    }
}

