/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.graph.Traverser;
import com.squareup.javapoet.ClassName;
import dagger.Reusable;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.Formatter;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor8;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;

@Reusable
final class DaggerElements
implements Elements {
    private final Elements elements;
    private final Types types;
    private static final Traverser<Element> GET_ENCLOSED_ELEMENTS = Traverser.forTree(Element::getEnclosedElements);
    private static final ElementVisitor<String, Void> ELEMENT_TO_STRING = new ElementKindVisitor8<String, Void>(){

        @Override
        public String visitExecutable(ExecutableElement executableElement, Void aVoid) {
            return this.enclosingTypeAndMemberName(executableElement).append(executableElement.getParameters().stream().map(parameter -> parameter.asType().toString()).collect(Collectors.joining(", ", "(", ")"))).toString();
        }

        @Override
        public String visitVariableAsParameter(VariableElement parameter, Void aVoid) {
            ExecutableElement methodOrConstructor = MoreElements.asExecutable(parameter.getEnclosingElement());
            return this.enclosingTypeAndMemberName(methodOrConstructor).append('(').append(Formatter.formatArgumentInList(methodOrConstructor.getParameters().indexOf(parameter), methodOrConstructor.getParameters().size(), parameter.getSimpleName())).append(')').toString();
        }

        @Override
        public String visitVariableAsField(VariableElement field, Void aVoid) {
            return this.enclosingTypeAndMemberName(field).toString();
        }

        @Override
        public String visitType(TypeElement type, Void aVoid) {
            return type.getQualifiedName().toString();
        }

        @Override
        protected String defaultAction(Element element, Void aVoid) {
            throw new UnsupportedOperationException("Can't determine string for " + (Object)((Object)element.getKind()) + " element " + element);
        }

        private StringBuilder enclosingTypeAndMemberName(Element element) {
            StringBuilder name = new StringBuilder(element.getEnclosingElement().accept(this, null));
            if (!element.getSimpleName().contentEquals("<init>")) {
                name.append('.').append(element.getSimpleName());
            }
            return name;
        }
    };
    private static final Formatter<Element> ELEMENT_FORMATTER = new Formatter<Element>(){

        @Override
        public String format(Element element) {
            return DaggerElements.elementToString(element);
        }
    };
    private static final ElementVisitor<TypeElement, Void> CLOSEST_ENCLOSING_TYPE_ELEMENT = new SimpleElementVisitor8<TypeElement, Void>(){

        @Override
        protected TypeElement defaultAction(Element element, Void p) {
            return element.getEnclosingElement().accept(this, null);
        }

        @Override
        public TypeElement visitType(TypeElement type, Void p) {
            return type;
        }
    };
    static final Comparator<Element> DECLARATION_ORDER = Comparator.comparing(element -> DaggerElements.siblings(element).indexOf(element));

    DaggerElements(Elements elements, Types types) {
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.types = (Types)Preconditions.checkNotNull((Object)types);
    }

    DaggerElements(ProcessingEnvironment processingEnv) {
        this(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
    }

    static boolean elementEncloses(TypeElement encloser, Element enclosed) {
        return Iterables.contains((Iterable)GET_ENCLOSED_ELEMENTS.breadthFirst((Object)encloser), (Object)enclosed);
    }

    ImmutableSet<ExecutableElement> getUnimplementedMethods(TypeElement type) {
        return FluentIterable.from(MoreElements.getLocalAndInheritedMethods(type, this.types, this.elements)).filter(MoreElements.hasModifiers(Modifier.ABSTRACT)).toSet();
    }

    TypeElement getTypeElement(Class<?> clazz) {
        return this.getTypeElement(clazz.getCanonicalName());
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        return this.elements.getTypeElement(name);
    }

    TypeElement getTypeElement(ClassName className) {
        return this.getTypeElement(className.withoutAnnotations().toString());
    }

    static String elementToString(Element element) {
        return element.accept(ELEMENT_TO_STRING, null);
    }

    static Formatter<Element> elementFormatter() {
        return ELEMENT_FORMATTER;
    }

    static TypeElement closestEnclosingTypeElement(Element element) {
        return element.accept(CLOSEST_ENCLOSING_TYPE_ELEMENT, null);
    }

    private static List<? extends Element> siblings(Element element) {
        return element.getKind().equals((Object)ElementKind.PARAMETER) ? MoreElements.asExecutable(element.getEnclosingElement()).getParameters() : element.getEnclosingElement().getEnclosedElements();
    }

    static boolean isAnyAnnotationPresent(Element element, Iterable<? extends Class<? extends Annotation>> annotationClasses) {
        for (Class<? extends Annotation> clazz : annotationClasses) {
            if (!MoreElements.isAnnotationPresent(element, clazz)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    static boolean isAnyAnnotationPresent(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... otherAnnotations) {
        return DaggerElements.isAnyAnnotationPresent(element, Lists.asList(first, (Object[])otherAnnotations));
    }

    static boolean isAnnotationPresent(Element element, TypeMirror annotationType) {
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).anyMatch(candidate -> MoreTypes.equivalence().equivalent(candidate, (Object)annotationType));
    }

    @SafeVarargs
    static Optional<AnnotationMirror> getAnyAnnotation(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... rest) {
        return DaggerElements.getAnyAnnotation(element, Lists.asList(first, (Object[])rest));
    }

    static Optional<AnnotationMirror> getAnyAnnotation(Element element, Collection<? extends Class<? extends Annotation>> annotations) {
        return element.getAnnotationMirrors().stream().filter(DaggerElements.hasAnnotationTypeIn(annotations)).map(a -> a).findFirst();
    }

    @SafeVarargs
    static ImmutableSet<AnnotationMirror> getAllAnnotations(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... rest) {
        return element.getAnnotationMirrors().stream().filter(DaggerElements.hasAnnotationTypeIn(Lists.asList(first, (Object[])rest))).collect(DaggerStreams.toImmutableSet());
    }

    static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return Optional.ofNullable((AnnotationMirror)MoreElements.getAnnotationMirror(element, annotationClass).orNull());
    }

    private static Predicate<AnnotationMirror> hasAnnotationTypeIn(Collection<? extends Class<? extends Annotation>> annotations) {
        Set annotationClassNames = annotations.stream().map(Class::getCanonicalName).collect(Collectors.toSet());
        return annotation -> annotationClassNames.contains(MoreTypes.asTypeElement(annotation.getAnnotationType()).getQualifiedName().toString());
    }

    static ImmutableSet<String> suppressedWarnings(Element element) {
        SuppressWarnings suppressedWarnings = element.getAnnotation(SuppressWarnings.class);
        if (suppressedWarnings == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Object[])suppressedWarnings.value());
    }

    TypeElement checkTypePresent(String typeName) {
        TypeElement type = this.elements.getTypeElement(typeName);
        if (type == null) {
            throw new TypeNotPresentException(typeName, null);
        }
        return type;
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        return this.elements.getPackageElement(name);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return this.elements.getElementValuesWithDefaults(a);
    }

    @Override
    public String getDocComment(Element e) {
        return this.elements.getDocComment(e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        return this.elements.isDeprecated(e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return this.elements.getBinaryName(type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        return this.elements.getPackageOf(type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        return this.elements.getAllMembers(type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.elements.getAllAnnotationMirrors(e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        return this.elements.hides(hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        return this.elements.overrides(overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return this.elements.getConstantExpression(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        this.elements.printElements(w, elements);
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.elements.getName(cs);
    }

    @Override
    public boolean isFunctionalInterface(TypeElement type) {
        return this.elements.isFunctionalInterface(type);
    }
}

