/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.ProcessingOptions;
import dagger.internal.codegen.Validation;
import dagger.spi.BindingGraphPlugin;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class BindingGraphPlugins {
    private final ImmutableSet<BindingGraphPlugin> plugins;
    private final Filer filer;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final Map<String, String> processingOptions;

    @Inject
    BindingGraphPlugins(@Validation Set<BindingGraphPlugin> validationPlugins, ImmutableSet<BindingGraphPlugin> externalPlugins, Filer filer, DaggerTypes types, DaggerElements elements, @ProcessingOptions Map<String, String> processingOptions) {
        this.plugins = Sets.union(validationPlugins, externalPlugins).immutableCopy();
        this.filer = filer;
        this.types = types;
        this.elements = elements;
        this.processingOptions = processingOptions;
    }

    ImmutableSet<String> allSupportedOptions() {
        return this.plugins.stream().flatMap(plugin -> plugin.supportedOptions().stream()).collect(DaggerStreams.toImmutableSet());
    }

    void initializePlugins() {
        this.plugins.forEach(this::initializePlugin);
    }

    private void initializePlugin(BindingGraphPlugin plugin) {
        plugin.initFiler(this.filer);
        plugin.initTypes((Types)this.types);
        plugin.initElements((Elements)this.elements);
        Set supportedOptions = plugin.supportedOptions();
        if (!supportedOptions.isEmpty()) {
            plugin.initOptions(Maps.filterKeys(this.processingOptions, supportedOptions::contains));
        }
    }
}

