/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.squareup.javapoet.MethodSpec;
import dagger.internal.codegen.AutoValue_ModifiableBindingMethods_ModifiableBindingMethod;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

final class ModifiableBindingMethods {
    private final Map<BindingRequest, ModifiableBindingMethod> methods = Maps.newLinkedHashMap();
    private final Set<BindingRequest> finalizedMethods = Sets.newHashSet();

    ModifiableBindingMethods() {
    }

    void addMethod(ModifiableBindingType type, BindingRequest request, TypeMirror returnType, MethodSpec method, boolean finalized) {
        ModifiableBindingMethod modifiableMethod;
        ModifiableBindingMethod previousMethod;
        Preconditions.checkArgument((boolean)type.isModifiable());
        if (finalized) {
            this.finalizedMethods.add(request);
        }
        Verify.verify(((previousMethod = this.methods.put(request, modifiableMethod = ModifiableBindingMethod.create(type, request, returnType, method, finalized))) == null ? 1 : 0) != 0, (String)"registering %s but %s is already registered for the same binding request", (Object)modifiableMethod, (Object)previousMethod);
    }

    ImmutableList<ModifiableBindingMethod> getNonFinalizedMethods() {
        return this.methods.values().stream().filter(m -> !m.finalized()).collect(DaggerStreams.toImmutableList());
    }

    Optional<ModifiableBindingMethod> getMethod(BindingRequest request) {
        return Optional.ofNullable(this.methods.get(request));
    }

    ImmutableList<ModifiableBindingMethod> allMethods() {
        return ImmutableList.copyOf(this.methods.values());
    }

    void methodImplemented(ModifiableBindingMethod method) {
        if (method.finalized()) {
            Preconditions.checkState((boolean)this.finalizedMethods.add(method.request()), (String)"Implementing and finalizing a modifiable binding method that has been marked as finalized in the current subcomponent implementation. The binding is for a %s of type %s.", (Object)method.request(), (Object)((Object)method.type()));
        }
    }

    boolean finalized(ModifiableBindingMethod method) {
        return this.finalizedMethods.contains(method.request());
    }

    @AutoValue
    static abstract class ModifiableBindingMethod {
        ModifiableBindingMethod() {
        }

        private static ModifiableBindingMethod create(ModifiableBindingType type, BindingRequest request, TypeMirror returnType, MethodSpec methodSpec, boolean finalized) {
            return new AutoValue_ModifiableBindingMethods_ModifiableBindingMethod(type, request, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)returnType), methodSpec, finalized);
        }

        static ModifiableBindingMethod implement(ModifiableBindingMethod unimplementedMethod, MethodSpec methodSpec, boolean finalized) {
            return new AutoValue_ModifiableBindingMethods_ModifiableBindingMethod(unimplementedMethod.type(), unimplementedMethod.request(), unimplementedMethod.returnTypeWrapper(), methodSpec, finalized);
        }

        abstract ModifiableBindingType type();

        abstract BindingRequest request();

        final TypeMirror returnType() {
            return (TypeMirror)this.returnTypeWrapper().get();
        }

        abstract Equivalence.Wrapper<TypeMirror> returnTypeWrapper();

        abstract MethodSpec methodSpec();

        abstract boolean finalized();

        boolean fulfillsSameRequestAs(ModifiableBindingMethod other) {
            return this.request().equals(other.request());
        }
    }
}

