/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import dagger.internal.codegen.AutoValue_ComponentTreeTraverser_ComponentTreePath;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.model.ComponentPath;
import dagger.model.DependencyRequest;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class ComponentTreeTraverser {
    private final Deque<BindingGraph> bindingGraphPath = new ArrayDeque<BindingGraph>();

    public ComponentTreeTraverser(BindingGraph rootGraph, CompilerOptions compilerOptions) {
        Preconditions.checkArgument((rootGraph.componentDescriptor().kind().isRoot() || compilerOptions.aheadOfTimeSubcomponents() ? 1 : 0) != 0, (String)"only root graphs can be traversed, not %s", (Object)rootGraph.componentTypeElement().getQualifiedName());
        this.bindingGraphPath.add(rootGraph);
    }

    public final void traverseComponents() {
        Preconditions.checkState((this.bindingGraphPath.size() == 1 ? 1 : 0) != 0);
        this.visitComponent(this.bindingGraphPath.getFirst());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitComponent(BindingGraph graph) {
        if (this.bindingGraphPath.size() > 1) {
            BindingGraph parent = (BindingGraph)Iterators.get(this.bindingGraphPath.descendingIterator(), (int)1);
            parent.componentDescriptor().getFactoryMethodForChildComponent(graph.componentDescriptor()).ifPresent(childFactoryMethod -> this.visitSubcomponentFactoryMethod(graph, parent, childFactoryMethod.methodElement()));
        }
        for (ComponentDescriptor.ComponentMethodDescriptor entryPointMethod : graph.componentDescriptor().entryPointMethods()) {
            this.visitEntryPoint(entryPointMethod.dependencyRequest().get(), graph);
        }
        for (BindingGraph child : graph.subgraphs()) {
            this.bindingGraphPath.addLast(child);
            try {
                this.visitComponent(child);
            }
            finally {
                Verify.verify((boolean)this.bindingGraphPath.removeLast().equals(child));
            }
        }
    }

    protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
    }

    protected void visitEntryPoint(DependencyRequest entryPoint, BindingGraph graph) {
    }

    protected final ComponentTreePath componentTreePath() {
        return ComponentTreePath.create(this.bindingGraphPath);
    }

    @AutoValue
    public static abstract class ComponentTreePath {
        private static ComponentTreePath create(Iterable<BindingGraph> path) {
            return new AutoValue_ComponentTreeTraverser_ComponentTreePath((ImmutableList<BindingGraph>)ImmutableList.copyOf(path));
        }

        public abstract ImmutableList<BindingGraph> graphsInPath();

        public BindingGraph currentGraph() {
            return (BindingGraph)Iterables.getLast(this.graphsInPath());
        }

        public TypeElement currentComponent() {
            return this.currentGraph().componentTypeElement();
        }

        public BindingGraph parentGraph() {
            Preconditions.checkState((!this.atRoot() ? 1 : 0) != 0);
            return (BindingGraph)this.graphsInPath().reverse().get(1);
        }

        public BindingGraph rootGraph() {
            return (BindingGraph)this.graphsInPath().get(0);
        }

        public boolean atRoot() {
            return this.graphsInPath().size() == 1;
        }

        public BindingGraph rootmostGraph(Iterable<ComponentDescriptor> components) {
            ImmutableSet set = ImmutableSet.copyOf(components);
            return this.rootmostGraph((? super BindingGraph graph) -> set.contains((Object)graph.componentDescriptor()));
        }

        public BindingGraph graphForComponent(ComponentDescriptor component) {
            Preconditions.checkNotNull((Object)component);
            return this.rootmostGraph((? super BindingGraph graph) -> graph.componentDescriptor().equals(component));
        }

        ComponentTreePath pathFromRootToAncestor(TypeElement ancestor) {
            ImmutableList.Builder path = ImmutableList.builder();
            for (BindingGraph graph : this.graphsInPath()) {
                path.add((Object)graph);
                if (!graph.componentTypeElement().equals(ancestor)) continue;
                return ComponentTreePath.create((Iterable<BindingGraph>)path.build());
            }
            throw new IllegalArgumentException(String.format("%s is not in the current path: %s", ancestor.getQualifiedName(), this));
        }

        ComponentTreePath childPath(TypeElement subcomponent) {
            for (BindingGraph child : this.currentGraph().subgraphs()) {
                if (!child.componentTypeElement().equals(subcomponent)) continue;
                return ComponentTreePath.create((Iterable<BindingGraph>)ImmutableList.builder().addAll(this.graphsInPath()).add((Object)child).build());
            }
            throw new IllegalArgumentException(String.format("%s is not a child of %s", subcomponent.getQualifiedName(), this.currentGraph().componentTypeElement().getQualifiedName()));
        }

        private BindingGraph rootmostGraph(Predicate<? super BindingGraph> predicate) {
            return this.graphsInPath().stream().filter(predicate).findFirst().get();
        }

        ComponentPath toComponentPath() {
            return ComponentPath.create((Iterable)this.graphsInPath().stream().map(BindingGraph::componentTypeElement).collect(Collectors.toList()));
        }

        public final String toString() {
            return this.graphsInPath().stream().map(BindingGraph::componentTypeElement).map(TypeElement::getQualifiedName).collect(Collectors.joining(" \u2192 "));
        }
    }
}

