/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DiagnosticFormatting;
import dagger.internal.codegen.SimpleAnnotationMirror;
import dagger.model.Scope;
import dagger.producers.ProductionScope;
import dagger.shaded.auto.common.AnnotationMirrors;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class Scopes {
    Scopes() {
    }

    static Scope scope(TypeElement scopeType) {
        return Scope.scope((AnnotationMirror)SimpleAnnotationMirror.of(scopeType));
    }

    static Scope productionScope(Elements elements) {
        return Scopes.scope(elements, ProductionScope.class);
    }

    static Scope singletonScope(Elements elements) {
        return Scopes.scope(elements, Singleton.class);
    }

    private static Scope scope(Elements elements, Class<? extends Annotation> scopeAnnotationClass) {
        return Scopes.scope(elements.getTypeElement(scopeAnnotationClass.getCanonicalName()));
    }

    static Optional<Scope> uniqueScopeOf(Element element) {
        return Optional.ofNullable((Scope)Iterables.getOnlyElement(Scopes.scopesOf(element), null));
    }

    static String getReadableSource(Scope scope) {
        return DiagnosticFormatting.stripCommonTypePrefixes(scope.toString());
    }

    static ImmutableSet<Scope> scopesOf(Element element) {
        return AnnotationMirrors.getAnnotatedAnnotations(element, javax.inject.Scope.class).stream().map(Scope::scope).collect(DaggerStreams.toImmutableSet());
    }
}

