/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MembersInjectionMethods;
import dagger.internal.codegen.ResolvedBindings;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

final class MembersInjectionBindingExpression
extends BindingExpression {
    private final MembersInjectionBinding binding;
    private final MembersInjectionMethods membersInjectionMethods;

    MembersInjectionBindingExpression(ResolvedBindings resolvedBindings, MembersInjectionMethods membersInjectionMethods) {
        this.binding = resolvedBindings.membersInjectionBinding().get();
        this.membersInjectionMethods = membersInjectionMethods;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        throw new UnsupportedOperationException(this.binding.toString());
    }

    @Override
    protected CodeBlock getComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        ExecutableElement methodElement = componentMethod.methodElement();
        ParameterSpec parameter = ParameterSpec.get((VariableElement)((VariableElement)Iterables.getOnlyElement(methodElement.getParameters())));
        if (this.binding.injectionSites().isEmpty()) {
            return methodElement.getReturnType().getKind().equals((Object)TypeKind.VOID) ? CodeBlock.of((String)"", (Object[])new Object[0]) : CodeBlock.of((String)"return $N;", (Object[])new Object[]{parameter});
        }
        return methodElement.getReturnType().getKind().equals((Object)TypeKind.VOID) ? CodeBlock.of((String)"$L;", (Object[])new Object[]{this.membersInjectionInvocation(parameter)}) : CodeBlock.of((String)"return $L;", (Object[])new Object[]{this.membersInjectionInvocation(parameter)});
    }

    CodeBlock membersInjectionInvocation(ParameterSpec target) {
        return CodeBlock.of((String)"$N($N)", (Object[])new Object[]{this.membersInjectionMethods.getOrCreate(this.binding.key()), target});
    }
}

