/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.RequestKinds;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.model.DependencyRequest;
import dagger.model.RequestKind;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class InjectionMethods {
    InjectionMethods() {
    }

    private static ImmutableList<CodeBlock> injectionMethodArguments(ImmutableSet<DependencyRequest> dependencies, Function<DependencyRequest, CodeBlock> dependencyUsage, ClassName requestingClass) {
        return dependencies.stream().map(dep -> InjectionMethods.injectionMethodArgument(dep, (CodeBlock)dependencyUsage.apply((DependencyRequest)dep), requestingClass)).collect(DaggerStreams.toImmutableList());
    }

    private static CodeBlock injectionMethodArgument(DependencyRequest dependency, CodeBlock argument, ClassName generatedTypeName) {
        TypeMirror keyType = dependency.key().type();
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        if (!Accessibility.isRawTypeAccessible(keyType, generatedTypeName.packageName()) && Accessibility.isTypeAccessibleFrom(keyType, generatedTypeName.packageName())) {
            if (!dependency.kind().equals((Object)RequestKind.INSTANCE)) {
                TypeName usageTypeName = InjectionMethods.accessibleType(dependency);
                codeBlock.add("($T) ($T)", new Object[]{usageTypeName, TypeNames.rawTypeName(usageTypeName)});
            } else if (((Element)dependency.requestElement().get()).asType().getKind().equals((Object)TypeKind.TYPEVAR)) {
                codeBlock.add("($T)", new Object[]{keyType});
            }
        }
        return codeBlock.add(argument).build();
    }

    private static TypeName accessibleType(DependencyRequest dependency) {
        TypeName typeName = RequestKinds.requestTypeName(dependency.kind(), InjectionMethods.accessibleType(dependency.key().type()));
        return dependency.requestElement().map(element -> element.asType().getKind().isPrimitive()).orElse(false) != false ? typeName.unbox() : typeName;
    }

    private static TypeName accessibleType(TypeMirror type) {
        return Accessibility.isRawTypePubliclyAccessible(type) ? TypeName.get((TypeMirror)type) : TypeName.OBJECT;
    }

    private static CodeBlock callInjectionMethod(String methodName, List<CodeBlock> arguments, ClassName enclosingClass, ClassName requestingClass) {
        CodeBlock.Builder invocation = CodeBlock.builder();
        if (!enclosingClass.equals((Object)requestingClass)) {
            invocation.add("$T.", new Object[]{enclosingClass});
        }
        return invocation.add("$L($L)", new Object[]{methodName, CodeBlocks.makeParametersCodeBlock(arguments)}).build();
    }

    private static CodeBlock instanceWithPotentialCast(CodeBlock instance, TypeMirror instanceType) {
        return Accessibility.isRawTypePubliclyAccessible(instanceType) ? instance : CodeBlock.of((String)"(($T) $L)", (Object[])new Object[]{instanceType, instance});
    }

    private static MethodSpec methodProxy(ExecutableElement method, String methodName, ReceiverAccessibility receiverAccessibility, CheckNotNullPolicy checkNotNullPolicy) {
        TypeElement enclosingType = MoreElements.asType(method.getEnclosingElement());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        UniqueNameSet nameSet = new UniqueNameSet();
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            methodBuilder.addParameter(receiverAccessibility.parameterType(enclosingType.asType()), nameSet.getUniqueName("instance"), new Modifier[0]);
        }
        CodeBlock arguments = InjectionMethods.copyParameters(method, methodBuilder, nameSet);
        if (!method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
            methodBuilder.returns(TypeName.get((TypeMirror)method.getReturnType()));
            ConfigurationAnnotations.getNullableType(method).ifPresent(nullableType -> CodeBlocks.addAnnotation(methodBuilder, nullableType));
            methodBuilder.addCode("return ", new Object[0]);
        }
        CodeBlock.Builder proxyInvocation = CodeBlock.builder();
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            proxyInvocation.add("$T", new Object[]{TypeNames.rawTypeName(TypeName.get((TypeMirror)enclosingType.asType()))});
        } else {
            InjectionMethods.copyTypeParameters(enclosingType, methodBuilder);
            proxyInvocation.add(receiverAccessibility.potentiallyCast(CodeBlock.of((String)"instance", (Object[])new Object[0]), enclosingType.asType()));
        }
        InjectionMethods.copyTypeParameters(method, methodBuilder);
        InjectionMethods.copyThrows(method, methodBuilder);
        proxyInvocation.add(".$N($L)", new Object[]{method.getSimpleName(), arguments});
        methodBuilder.addCode(checkNotNullPolicy.checkForNull(proxyInvocation.build())).addCode(";", new Object[0]);
        return methodBuilder.build();
    }

    private static MethodSpec fieldProxy(VariableElement field, String methodName) {
        TypeElement enclosingType = MoreElements.asType(field.getEnclosingElement());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        InjectionMethods.copyTypeParameters(enclosingType, methodBuilder);
        UniqueNameSet nameSet = new UniqueNameSet();
        String instanceName = nameSet.getUniqueName("instance");
        methodBuilder.addParameter(InjectionMethods.accessibleType(enclosingType.asType()), instanceName, new Modifier[0]);
        return methodBuilder.addCode("$L.$L = $L;", new Object[]{InjectionMethods.instanceWithPotentialCast(CodeBlock.of((String)instanceName, (Object[])new Object[0]), enclosingType.asType()), field.getSimpleName(), InjectionMethods.copyParameter(field, methodBuilder, nameSet)}).build();
    }

    private static void copyThrows(ExecutableElement method, MethodSpec.Builder methodBuilder) {
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            methodBuilder.addException(TypeName.get((TypeMirror)typeMirror));
        }
    }

    private static CodeBlock copyParameters(ExecutableElement method, MethodSpec.Builder methodBuilder, UniqueNameSet nameSet) {
        ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
        for (VariableElement variableElement : method.getParameters()) {
            argumentsBuilder.add((Object)InjectionMethods.copyParameter(variableElement, methodBuilder, nameSet));
        }
        methodBuilder.varargs(method.isVarArgs());
        return CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)argumentsBuilder.build());
    }

    private static CodeBlock copyParameter(VariableElement element, MethodSpec.Builder methodBuilder, UniqueNameSet nameSet) {
        TypeMirror elementType = element.asType();
        boolean useObject = !Accessibility.isRawTypePubliclyAccessible(elementType);
        ClassName typeName = useObject ? TypeName.OBJECT : TypeName.get((TypeMirror)elementType);
        String name = nameSet.getUniqueName(element.getSimpleName().toString());
        ParameterSpec parameter = ParameterSpec.builder((TypeName)typeName, (String)name, (Modifier[])new Modifier[0]).build();
        methodBuilder.addParameter(parameter);
        return useObject ? CodeBlock.of((String)"($T) $N", (Object[])new Object[]{elementType, parameter}) : CodeBlock.of((String)"$N", (Object[])new Object[]{parameter});
    }

    private static void copyTypeParameters(Parameterizable parameterizable, MethodSpec.Builder methodBuilder) {
        for (TypeParameterElement typeParameterElement : parameterizable.getTypeParameters()) {
            methodBuilder.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
    }

    private static enum CheckNotNullPolicy {
        IGNORE,
        CHECK_FOR_NULL;


        CodeBlock checkForNull(CodeBlock maybeNull) {
            if (this.equals((Object)IGNORE)) {
                return maybeNull;
            }
            return FactoryGenerator.checkNotNullProvidesMethod(maybeNull);
        }

        static CheckNotNullPolicy get(ProvisionBinding binding, CompilerOptions compilerOptions) {
            return binding.shouldCheckForNull(compilerOptions) ? CHECK_FOR_NULL : IGNORE;
        }
    }

    private static enum ReceiverAccessibility {
        CAST_IF_NOT_PUBLIC{

            @Override
            TypeName parameterType(TypeMirror type) {
                return InjectionMethods.accessibleType(type);
            }

            @Override
            CodeBlock potentiallyCast(CodeBlock instance, TypeMirror instanceType) {
                return InjectionMethods.instanceWithPotentialCast(instance, instanceType);
            }
        }
        ,
        IGNORE{

            @Override
            TypeName parameterType(TypeMirror type) {
                return TypeName.get((TypeMirror)type);
            }

            @Override
            CodeBlock potentiallyCast(CodeBlock instance, TypeMirror instanceType) {
                return instance;
            }
        };


        abstract TypeName parameterType(TypeMirror var1);

        abstract CodeBlock potentiallyCast(CodeBlock var1, TypeMirror var2);
    }

    static final class InjectionSiteMethod {
        InjectionSiteMethod() {
        }

        static MethodSpec create(MembersInjectionBinding.InjectionSite injectionSite) {
            String methodName = InjectionSiteMethod.methodName(injectionSite);
            switch (injectionSite.kind()) {
                case METHOD: {
                    return InjectionMethods.methodProxy(MoreElements.asExecutable(injectionSite.element()), methodName, ReceiverAccessibility.CAST_IF_NOT_PUBLIC, CheckNotNullPolicy.IGNORE);
                }
                case FIELD: {
                    return InjectionMethods.fieldProxy(MoreElements.asVariable(injectionSite.element()), methodName);
                }
            }
            throw new AssertionError(injectionSite);
        }

        static CodeBlock invokeAll(ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites, ClassName generatedTypeName, CodeBlock instanceCodeBlock, TypeMirror instanceType, Types types, Function<DependencyRequest, CodeBlock> dependencyUsage) {
            return injectionSites.stream().map(injectionSite -> {
                TypeMirror injectSiteType = types.erasure(injectionSite.element().getEnclosingElement().asType());
                CodeBlock maybeCastedInstance = !types.isSubtype(instanceType, injectSiteType) && Accessibility.isTypeAccessibleFrom(injectSiteType, generatedTypeName.packageName()) ? CodeBlock.of((String)"($T) $L", (Object[])new Object[]{injectSiteType, instanceCodeBlock}) : instanceCodeBlock;
                return CodeBlock.of((String)"$L;", (Object[])new Object[]{InjectionSiteMethod.invoke(injectionSite, generatedTypeName, maybeCastedInstance, dependencyUsage)});
            }).collect(CodeBlocks.toConcatenatedCodeBlock());
        }

        private static CodeBlock invoke(MembersInjectionBinding.InjectionSite injectionSite, ClassName generatedTypeName, CodeBlock instanceCodeBlock, Function<DependencyRequest, CodeBlock> dependencyUsage) {
            ArrayList<CodeBlock> arguments = new ArrayList<CodeBlock>();
            arguments.add(instanceCodeBlock);
            if (!injectionSite.dependencies().isEmpty()) {
                arguments.addAll(injectionSite.dependencies().stream().map(dependencyUsage).collect(Collectors.toList()));
            }
            return InjectionMethods.callInjectionMethod(InjectionSiteMethod.create((MembersInjectionBinding.InjectionSite)injectionSite).name, arguments, SourceFiles.membersInjectorNameForType(MoreElements.asType(injectionSite.element().getEnclosingElement())), generatedTypeName);
        }

        private static String methodName(MembersInjectionBinding.InjectionSite injectionSite) {
            int index = injectionSite.indexAmongAtInjectMembersWithSameSimpleName();
            String indexString = index == 0 ? "" : String.valueOf(index + 1);
            return "inject" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, injectionSite.element().getSimpleName().toString()) + indexString;
        }
    }

    static final class ProvisionMethod {
        ProvisionMethod() {
        }

        static MethodSpec create(ProvisionBinding binding, CompilerOptions compilerOptions) {
            ExecutableElement element = MoreElements.asExecutable(binding.bindingElement().get());
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    return ProvisionMethod.constructorProxy(element);
                }
                case METHOD: {
                    return InjectionMethods.methodProxy(element, ProvisionMethod.methodName(element), ReceiverAccessibility.IGNORE, CheckNotNullPolicy.get(binding, compilerOptions));
                }
            }
            throw new AssertionError(element);
        }

        static CodeBlock invoke(ProvisionBinding binding, Function<DependencyRequest, CodeBlock> dependencyUsage, ClassName requestingClass, Optional<CodeBlock> moduleReference, CompilerOptions compilerOptions) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            moduleReference.ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            arguments.addAll((Iterable)InjectionMethods.injectionMethodArguments((ImmutableSet<DependencyRequest>)binding.provisionDependencies(), dependencyUsage, requestingClass));
            return InjectionMethods.callInjectionMethod(ProvisionMethod.create((ProvisionBinding)binding, (CompilerOptions)compilerOptions).name, (List)arguments.build(), SourceFiles.generatedClassNameForBinding(binding), requestingClass);
        }

        private static MethodSpec constructorProxy(ExecutableElement constructor) {
            UniqueNameSet names = new UniqueNameSet();
            TypeElement enclosingType = MoreElements.asType(constructor.getEnclosingElement());
            MethodSpec.Builder method = MethodSpec.methodBuilder((String)ProvisionMethod.methodName(constructor)).returns(TypeName.get((TypeMirror)enclosingType.asType())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            InjectionMethods.copyTypeParameters(enclosingType, method);
            InjectionMethods.copyThrows(constructor, method);
            return method.addStatement("return new $T($L)", new Object[]{enclosingType, InjectionMethods.copyParameters(constructor, method, names)}).build();
        }

        static boolean requiresInjectionMethod(ProvisionBinding binding, ImmutableList<Expression> arguments, CompilerOptions compilerOptions, String callingPackage, DaggerTypes types) {
            ExecutableElement method = MoreElements.asExecutable(binding.bindingElement().get());
            return !binding.injectionSites().isEmpty() || binding.shouldCheckForNull(compilerOptions) || !Accessibility.isElementAccessibleFrom((Element)method, callingPackage) || !ProvisionMethod.areParametersAssignable(method, arguments, types) || method.getParameters().stream().map(Element::asType).anyMatch(type -> !Accessibility.isRawTypeAccessible(type, callingPackage));
        }

        private static boolean areParametersAssignable(ExecutableElement element, ImmutableList<Expression> arguments, DaggerTypes types) {
            List<? extends VariableElement> parameters = element.getParameters();
            Preconditions.checkArgument((parameters.size() == arguments.size() ? 1 : 0) != 0);
            for (int i = 0; i < parameters.size(); ++i) {
                if (types.isAssignable(((Expression)arguments.get(i)).type(), parameters.get(i).asType())) continue;
                return false;
            }
            return true;
        }

        private static String methodName(ExecutableElement method) {
            switch (method.getKind()) {
                case CONSTRUCTOR: {
                    return "new" + method.getEnclosingElement().getSimpleName();
                }
                case METHOD: {
                    return "proxy" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, method.getSimpleName().toString());
                }
            }
            throw new AssertionError(method);
        }
    }
}

