/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.ComponentTreeTraverser;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.RequestKinds;
import dagger.model.DependencyRequest;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor8;

final class DependencyRequestFormatter
extends Formatter<DependencyRequest> {
    private final DaggerTypes types;
    private final ElementVisitor<String, DependencyRequest> formatVisitor = new ElementKindVisitor8<String, DependencyRequest>(){

        @Override
        public String visitExecutableAsMethod(ExecutableElement method, DependencyRequest request) {
            return "    " + request.key() + " is " + DependencyRequestFormatter.this.componentMethodRequestVerb(request) + " at\n" + "        " + DaggerElements.elementToString(method);
        }

        @Override
        public String visitVariable(VariableElement variable, DependencyRequest request) {
            TypeMirror requestedType = RequestKinds.requestType(request.kind(), request.key().type(), DependencyRequestFormatter.this.types);
            return "    " + DependencyRequestFormatter.this.formatQualifier(request.key().qualifier()) + requestedType + " is injected at\n" + "        " + DaggerElements.elementToString(variable);
        }

        @Override
        public String visitType(TypeElement e, DependencyRequest request) {
            return "";
        }

        @Override
        protected String defaultAction(Element element, DependencyRequest request) {
            throw new IllegalStateException("Invalid request " + (Object)((Object)element.getKind()) + " element " + element);
        }
    };

    @Inject
    DependencyRequestFormatter(DaggerTypes types) {
        this.types = types;
    }

    @Override
    String format(ComponentTreeTraverser.DependencyTrace dependencyTrace) {
        AtomicReference<ImmutableSet> dependentOptionalBindingDeclarations = new AtomicReference<ImmutableSet>(ImmutableSet.of());
        return Joiner.on((char)'\n').join((Iterable)dependencyTrace.transform((dependencyRequest, resolvedBindings) -> {
            ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations = dependentOptionalBindingDeclarations.getAndSet(resolvedBindings.optionalBindingDeclarations());
            return optionalBindingDeclarations.isEmpty() ? this.format((DependencyRequest)dependencyRequest) : this.formatSyntheticOptionalBindingDependency(optionalBindingDeclarations);
        }).filter(f -> !f.isEmpty()).collect(DaggerStreams.toImmutableList()).reverse());
    }

    @Override
    public String format(DependencyRequest request) {
        return request.requestElement().map(element -> element.accept(this.formatVisitor, request)).orElse("");
    }

    @CanIgnoreReturnValue
    StringBuilder appendFormatLine(StringBuilder builder, DependencyRequest dependencyRequest) {
        String formatted = this.format(dependencyRequest);
        if (!formatted.isEmpty()) {
            builder.append('\n').append(formatted);
        }
        return builder;
    }

    private String formatQualifier(Optional<AnnotationMirror> maybeQualifier) {
        return maybeQualifier.map(qualifier -> qualifier + " ").orElse("");
    }

    private String componentMethodRequestVerb(DependencyRequest request) {
        switch (request.kind()) {
            case FUTURE: 
            case PRODUCER: {
                return "produced";
            }
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: 
            case PROVIDER_OF_LAZY: {
                return "provided";
            }
            case MEMBERS_INJECTION: {
                return "injected";
            }
        }
        throw new AssertionError((Object)("illegal request kind for method: " + request));
    }

    private String formatSyntheticOptionalBindingDependency(ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations) {
        OptionalBindingDeclaration optionalBindingDeclaration = (OptionalBindingDeclaration)optionalBindingDeclarations.iterator().next();
        StringBuilder builder = new StringBuilder();
        builder.append("    ").append("@BindsOptionalOf ").append(optionalBindingDeclaration.key()).append(" is declared at\n").append("        ").append(DaggerElements.elementToString(optionalBindingDeclaration.bindingElement().get()));
        if (optionalBindingDeclarations.size() > 1) {
            builder.append(", among others");
        }
        return builder.toString();
    }
}

