/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.googlejavaformat.java.filer.FormattingFiler;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.Reusable;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.ProcessingOptions;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Module(includes={ElementsModule.class})
final class ProcessingEnvironmentModule {
    private final ProcessingEnvironment processingEnvironment;

    ProcessingEnvironmentModule(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = (ProcessingEnvironment)Preconditions.checkNotNull((Object)processingEnvironment);
    }

    @Provides
    @ProcessingOptions
    Map<String, String> processingOptions() {
        return this.processingEnvironment.getOptions();
    }

    @Provides
    Messager messager() {
        return this.processingEnvironment.getMessager();
    }

    @Provides
    @Reusable
    Filer filer(CompilerOptions compilerOptions, Messager messager) {
        if (compilerOptions.headerCompilation()) {
            return this.processingEnvironment.getFiler();
        }
        return new FormattingFiler(this.processingEnvironment.getFiler());
    }

    @Provides
    Types types() {
        return this.processingEnvironment.getTypeUtils();
    }

    @Provides
    SourceVersion sourceVersion() {
        return this.processingEnvironment.getSourceVersion();
    }

    @Provides
    DaggerElements daggerElements() {
        return new DaggerElements(this.processingEnvironment);
    }

    @Provides
    @Reusable
    CompilerOptions compilerOptions(DaggerElements elements) {
        return CompilerOptions.create(this.processingEnvironment, elements);
    }

    @Module
    static interface ElementsModule {
        @Binds
        public Elements elements(DaggerElements var1);
    }
}

