/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.DaggerStreams;
import dagger.model.BindingGraph;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import javax.inject.Inject;

final class NonNullableRequestForNullableBindingValidation
implements BindingGraphPlugin {
    private final CompilerOptions compilerOptions;

    @Inject
    NonNullableRequestForNullableBindingValidation(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        for (BindingGraph.BindingNode bindingNode : this.nullableBindings(bindingGraph)) {
            for (BindingGraph.DependencyEdge dependencyEdge : this.nonNullableDependencies(bindingGraph, bindingNode)) {
                diagnosticReporter.reportDependency(this.compilerOptions.nullableValidationKind(), dependencyEdge, NonNullableRequestForNullableBindingValidation.nullableToNonNullable(bindingNode.binding().key().toString(), bindingNode.toString()));
            }
        }
    }

    public String pluginName() {
        return "Dagger/Nullable";
    }

    private ImmutableList<BindingGraph.BindingNode> nullableBindings(BindingGraph bindingGraph) {
        return bindingGraph.bindingNodes().stream().filter(bindingNode -> bindingNode.binding().isNullable()).collect(DaggerStreams.toImmutableList());
    }

    private ImmutableList<BindingGraph.DependencyEdge> nonNullableDependencies(BindingGraph bindingGraph, BindingGraph.BindingNode bindingNode) {
        return bindingGraph.inEdges((Object)bindingNode).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).filter(edge -> !edge.dependencyRequest().isNullable()).collect(DaggerStreams.toImmutableList());
    }

    @VisibleForTesting
    static String nullableToNonNullable(String key, String binding) {
        return String.format("%s is not nullable, but is being provided by %s", key, binding);
    }
}

