/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class InjectionAnnotations {
    static Optional<AnnotationMirror> getQualifier(Element e) {
        Preconditions.checkNotNull((Object)e);
        ImmutableSet<? extends AnnotationMirror> qualifierAnnotations = InjectionAnnotations.getQualifiers(e);
        switch (qualifierAnnotations.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((AnnotationMirror)qualifierAnnotations.iterator().next());
            }
        }
        throw new IllegalArgumentException(e + " was annotated with more than one @Qualifier annotation");
    }

    static ImmutableSet<? extends AnnotationMirror> getQualifiers(Element element) {
        return AnnotationMirrors.getAnnotatedAnnotations(element, Qualifier.class);
    }

    static ImmutableSet<ExecutableElement> injectedConstructors(TypeElement type) {
        return FluentIterable.from(ElementFilter.constructorsIn(type.getEnclosedElements())).filter(constructor -> MoreElements.isAnnotationPresent(constructor, Inject.class)).toSet();
    }

    private InjectionAnnotations() {
    }
}

