/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.graph.SuccessorsFunction;
import dagger.internal.codegen.DependencyRequestFormatter;
import dagger.model.BindingGraph;
import dagger.model.DependencyRequest;
import dagger.spi.ValidationItem;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class SpiDiagnosticReporter {
    private final Messager messager;
    private final DependencyRequestFormatter dependencyRequestFormatter;

    @Inject
    SpiDiagnosticReporter(Messager messager, DependencyRequestFormatter dependencyRequestFormatter) {
        this.messager = messager;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
    }

    void report(BindingGraph graph, ImmutableListMultimap<String, ValidationItem> items) {
        for (Map.Entry entry : items.entries()) {
            new Worker(graph, (String)entry.getKey(), (ValidationItem)entry.getValue()).report();
        }
    }

    private static boolean isInstance(Optional<?> optional, Class<?> clazz) {
        return optional.filter(clazz::isInstance).isPresent();
    }

    private static <N> ImmutableList<N> shortestPath(SuccessorsFunction<N> graph, N nodeU, N nodeV) {
        if (nodeU.equals(nodeV)) {
            return ImmutableList.of(nodeU);
        }
        ImmutableSet successors = ImmutableSet.copyOf((Iterable)graph.successors(nodeU));
        if (successors.contains(nodeV)) {
            return ImmutableList.of(nodeU, nodeV);
        }
        HashMap<Object, Object> visitedNodeToPathPredecessor = new HashMap<Object, Object>();
        ArrayDeque currentNodes = new ArrayDeque();
        ArrayDeque nextNodes = new ArrayDeque();
        for (Object node : successors) {
            visitedNodeToPathPredecessor.put(node, nodeU);
        }
        currentNodes.addAll(successors);
        while (!currentNodes.isEmpty()) {
            while (!currentNodes.isEmpty()) {
                Object currentNode = currentNodes.remove();
                for (Object nextNode : graph.successors(currentNode)) {
                    if (visitedNodeToPathPredecessor.containsKey(nextNode)) continue;
                    visitedNodeToPathPredecessor.put(nextNode, currentNode);
                    if (nextNode.equals(nodeV)) {
                        ImmutableList.Builder builder = ImmutableList.builder();
                        Object node = nodeV;
                        builder.add(node);
                        while (!node.equals(nodeU)) {
                            node = visitedNodeToPathPredecessor.get(node);
                            builder.add(node);
                        }
                        return builder.build().reverse();
                    }
                    nextNodes.add(nextNode);
                }
            }
            ArrayDeque emptyQueue = currentNodes;
            currentNodes = nextNodes;
            nextNodes = emptyQueue;
        }
        return ImmutableList.of();
    }

    private class Worker {
        private final BindingGraph graph;
        private final String plugin;
        private final ValidationItem item;
        private final TypeElement rootComponent;

        Worker(BindingGraph graph, String plugin, ValidationItem item) {
            this.graph = graph;
            this.plugin = plugin;
            this.item = item;
            this.rootComponent = graph.rootComponentNode().componentPath().currentComponent();
        }

        private void report() {
            if (SpiDiagnosticReporter.isInstance(this.item.node(), BindingGraph.ComponentNode.class)) {
                this.reportComponent((BindingGraph.ComponentNode)this.item.node().get());
            } else if (SpiDiagnosticReporter.isInstance(this.item.node(), BindingGraph.BindingNode.class)) {
                this.reportBinding((BindingGraph.BindingNode)this.item.node().get());
            } else if (SpiDiagnosticReporter.isInstance(this.item.edge(), BindingGraph.DependencyEdge.class)) {
                this.reportDependencyRequest((BindingGraph.DependencyEdge)this.item.edge().get());
            } else {
                throw new AssertionError((Object)("Unknown ValidationItem kind: " + this.item));
            }
        }

        private void reportComponent(BindingGraph.ComponentNode node) {
            CharSequence message = this.messageBuilder();
            if (!node.componentPath().currentComponent().equals(this.rootComponent)) {
                message = this.appendComponentPath(message, (BindingGraph.Node)node);
            }
            SpiDiagnosticReporter.this.messager.printMessage(this.item.diagnosticKind(), message, this.rootComponent);
        }

        private void reportBinding(BindingGraph.BindingNode targetNode) {
            this.reportAtEntryPointsWithDependencyTrace(targetNode, this.messageBuilder());
        }

        private void reportDependencyRequest(BindingGraph.DependencyEdge edge) {
            StringBuilder message = this.messageBuilder().append('\n').append(SpiDiagnosticReporter.this.dependencyRequestFormatter.format(edge.dependencyRequest()));
            if (edge.isEntryPoint()) {
                this.printAtEntryPoint(edge, message);
            } else {
                BindingGraph.BindingNode sourceNode = (BindingGraph.BindingNode)this.graph.incidentNodes((Object)edge).source();
                this.reportAtEntryPointsWithDependencyTrace(sourceNode, message);
            }
        }

        private void reportAtEntryPointsWithDependencyTrace(BindingGraph.BindingNode targetNode, CharSequence baseMessage) {
            for (BindingGraph.DependencyEdge entryPoint : this.graph.entryPointEdgesDependingOnBindingNode(targetNode)) {
                this.printAtEntryPoint(entryPoint, new StringBuilder(baseMessage).append(this.dependencyTrace(entryPoint, targetNode)));
            }
        }

        private CharSequence dependencyTrace(BindingGraph.DependencyEdge entryPoint, BindingGraph.BindingNode targetNode) {
            Preconditions.checkArgument((boolean)entryPoint.isEntryPoint());
            BindingGraph.Node entryPointBinding = (BindingGraph.Node)this.graph.incidentNodes((Object)entryPoint).target();
            ImmutableList shortestPath = SpiDiagnosticReporter.shortestPath(node -> Sets.filter((Set)this.graph.successors(node), BindingGraph.BindingNode.class::isInstance), entryPointBinding, targetNode);
            StringBuilder trace = new StringBuilder(shortestPath.size() * 100);
            for (int i = shortestPath.size() - 1; i > 0; --i) {
                Set dependenciesBetween = this.graph.edgesConnecting((Object)((BindingGraph.Node)shortestPath.get(i - 1)), (Object)((BindingGraph.Node)shortestPath.get(i)));
                DependencyRequest dependencyRequest = ((BindingGraph.DependencyEdge)Iterables.get((Iterable)dependenciesBetween, (int)0)).dependencyRequest();
                trace.append('\n').append(SpiDiagnosticReporter.this.dependencyRequestFormatter.format(dependencyRequest));
            }
            trace.append('\n').append(SpiDiagnosticReporter.this.dependencyRequestFormatter.format(entryPoint.dependencyRequest()));
            return trace;
        }

        private void printAtEntryPoint(BindingGraph.DependencyEdge entryPoint, CharSequence message) {
            Preconditions.checkArgument((boolean)entryPoint.isEntryPoint());
            Element entryPointElement = (Element)entryPoint.dependencyRequest().requestElement().get();
            Element elementToReport = this.rootComponent.getEnclosedElements().contains(entryPointElement) ? entryPointElement : this.rootComponent;
            BindingGraph.Node component = (BindingGraph.Node)this.graph.incidentNodes((Object)entryPoint).source();
            if (!component.equals(this.graph.rootComponentNode())) {
                message = this.appendComponentPath(message, component);
            }
            SpiDiagnosticReporter.this.messager.printMessage(this.item.diagnosticKind(), message, elementToReport);
        }

        private CharSequence appendComponentPath(CharSequence message, BindingGraph.Node node) {
            return new StringBuilder(message).append("\ncomponent path: ").append(node.componentPath());
        }

        private StringBuilder messageBuilder() {
            return new StringBuilder(String.format("[%s] ", this.plugin)).append(this.item.message());
        }
    }
}

