/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.MemoizedSentinel;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingVariableNamer;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.RequestKind;
import javax.lang.model.element.Modifier;

final class ScopedInstanceMethodImplementation
extends BindingMethodImplementation {
    private final GeneratedComponentModel generatedComponentModel;
    private final ContributionBinding binding;
    private final Supplier<String> fieldName = Suppliers.memoize(this::createField);

    ScopedInstanceMethodImplementation(ResolvedBindings resolvedBindings, RequestKind requestKind, BindingExpression bindingExpression, DaggerTypes types, GeneratedComponentModel generatedComponentModel) {
        super(resolvedBindings, requestKind, bindingExpression, generatedComponentModel.name(), types);
        this.generatedComponentModel = generatedComponentModel;
        this.binding = resolvedBindings.contributionBinding();
        Preconditions.checkArgument((boolean)this.binding.scope().isPresent(), (String)"expected binding to be scoped: %s", (Object)this.binding);
    }

    @Override
    CodeBlock body() {
        return this.binding.scope().get().isReusable() ? this.singleCheck() : this.doubleCheck();
    }

    private CodeBlock singleCheck() {
        return CodeBlock.builder().beginControlFlow("if ($N instanceof $T)", new Object[]{this.fieldName.get(), MemoizedSentinel.class}).addStatement("$N = $L", new Object[]{this.fieldName.get(), this.simpleBindingExpression()}).endControlFlow().addStatement("return ($T) $N", new Object[]{this.returnType(), this.fieldName.get()}).build();
    }

    private CodeBlock doubleCheck() {
        String fieldExpression = ((String)this.fieldName.get()).equals("local") ? "this." + (String)this.fieldName.get() : (String)this.fieldName.get();
        return CodeBlock.builder().addStatement("$T local = $L", new Object[]{TypeName.OBJECT, fieldExpression}).beginControlFlow("if (local instanceof $T)", new Object[]{MemoizedSentinel.class}).beginControlFlow("synchronized (local)", new Object[0]).beginControlFlow("if (local == $L)", new Object[]{fieldExpression}).addStatement("$L = $L", new Object[]{fieldExpression, this.simpleBindingExpression()}).endControlFlow().addStatement("local = $L", new Object[]{fieldExpression}).endControlFlow().endControlFlow().addStatement("return ($T) local", new Object[]{this.returnType()}).build();
    }

    private String createField() {
        String name = this.generatedComponentModel.getUniqueFieldName(BindingVariableNamer.name(this.binding));
        this.generatedComponentModel.addField(GeneratedComponentModel.FieldSpecKind.PRIVATE_METHOD_SCOPED_FIELD, FieldSpec.builder((TypeName)TypeName.OBJECT, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).initializer("new $T()", new Object[]{MemoizedSentinel.class}).build());
        return name;
    }
}

