/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.DiagnosticFormatting;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class MethodSignatureFormatter
extends Formatter<ExecutableElement> {
    private final Types types;

    @Inject
    MethodSignatureFormatter(Types types) {
        this.types = types;
    }

    @Override
    public String format(ExecutableElement method) {
        return this.format(method, Optional.empty());
    }

    public String format(ExecutableElement method, Optional<DeclaredType> container) {
        List<? extends AnnotationMirror> annotations;
        StringBuilder builder = new StringBuilder();
        TypeElement type = MoreElements.asType(method.getEnclosingElement());
        ExecutableType executableType = MoreTypes.asExecutable(method.asType());
        if (container.isPresent()) {
            executableType = MoreTypes.asExecutable(this.types.asMemberOf(container.get(), method));
            type = MoreElements.asType(container.get().asElement());
        }
        if (!(annotations = method.getAnnotationMirrors()).isEmpty()) {
            Iterator<? extends AnnotationMirror> annotationIterator = annotations.iterator();
            int i = 0;
            while (annotationIterator.hasNext()) {
                if (i > 0) {
                    builder.append(' ');
                }
                builder.append(ErrorMessages.format(annotationIterator.next()));
                ++i;
            }
            builder.append(' ');
        }
        builder.append(MethodSignatureFormatter.nameOfType(executableType.getReturnType()));
        builder.append(' ');
        builder.append(type.getQualifiedName());
        builder.append('.');
        builder.append(method.getSimpleName());
        builder.append('(');
        Preconditions.checkState((method.getParameters().size() == executableType.getParameterTypes().size() ? 1 : 0) != 0);
        Iterator<? extends VariableElement> parameters = method.getParameters().iterator();
        Iterator<? extends TypeMirror> parameterTypes = executableType.getParameterTypes().iterator();
        int i = 0;
        while (parameters.hasNext()) {
            if (i > 0) {
                builder.append(", ");
            }
            MethodSignatureFormatter.appendParameter(builder, parameters.next(), parameterTypes.next());
            ++i;
        }
        builder.append(')');
        return builder.toString();
    }

    private static void appendParameter(StringBuilder builder, VariableElement parameter, TypeMirror type) {
        InjectionAnnotations.getQualifier(parameter).ifPresent(qualifier -> builder.append(ErrorMessages.format(qualifier)).append(' '));
        builder.append(MethodSignatureFormatter.nameOfType(type));
    }

    private static String nameOfType(TypeMirror type) {
        return DiagnosticFormatting.stripCommonTypePrefixes(type.toString());
    }
}

