/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkInstanceSupplier;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.RequestKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class FrameworkInstanceBindingExpression
extends BindingExpression {
    private final ResolvedBindings resolvedBindings;
    private final RequestKind requestKind;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final FrameworkInstanceSupplier frameworkInstanceSupplier;
    private final FrameworkType frameworkType;
    private final DaggerTypes types;
    private final Elements elements;

    FrameworkInstanceBindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind, ComponentBindingExpressions componentBindingExpressions, FrameworkType frameworkType, FrameworkInstanceSupplier frameworkInstanceSupplier, DaggerTypes types, Elements elements) {
        this.resolvedBindings = (ResolvedBindings)Preconditions.checkNotNull((Object)resolvedBindings);
        this.requestKind = (RequestKind)Preconditions.checkNotNull((Object)requestKind);
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.frameworkType = (FrameworkType)((Object)Preconditions.checkNotNull((Object)((Object)frameworkType)));
        this.frameworkInstanceSupplier = (FrameworkInstanceSupplier)Preconditions.checkNotNull((Object)frameworkInstanceSupplier);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        if (this.requestKind.equals((Object)this.frameworkRequestKind())) {
            MemberSelect memberSelect = this.frameworkInstanceSupplier.memberSelect();
            TypeMirror contributedType = this.resolvedBindings.contributionBinding().contributedType();
            TypeMirror expressionType = this.frameworkInstanceSupplier.specificType().isPresent() || Accessibility.isTypeAccessibleFrom(contributedType, requestingClass.packageName()) || FrameworkInstanceBindingExpression.isInlinedFactoryCreation(memberSelect) ? this.types.wrapType(contributedType, this.resolvedBindings.frameworkClass()) : this.rawFrameworkType();
            return Expression.create(expressionType, memberSelect.getExpressionFor(requestingClass));
        }
        return this.frameworkType.to(this.requestKind, this.componentBindingExpressions.getDependencyExpression(this.resolvedBindings.key(), this.frameworkRequestKind(), requestingClass), this.types);
    }

    private RequestKind frameworkRequestKind() {
        switch (this.frameworkType) {
            case PROVIDER: {
                return RequestKind.PROVIDER;
            }
            case PRODUCER: {
                return RequestKind.PRODUCER;
            }
        }
        throw new AssertionError((Object)this.frameworkType);
    }

    private static boolean isInlinedFactoryCreation(MemberSelect memberSelect) {
        return memberSelect.staticMember();
    }

    private DeclaredType rawFrameworkType() {
        return this.types.getDeclaredType(this.elements.getTypeElement(this.resolvedBindings.frameworkClass().getCanonicalName()), new TypeMirror[0]);
    }
}

