/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.DelegateFactory;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.FrameworkInstanceSupplier;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.ResolvedBindings;
import java.util.Optional;
import javax.lang.model.element.Modifier;

class FrameworkFieldInitializer
implements FrameworkInstanceSupplier {
    private final GeneratedComponentModel generatedComponentModel;
    private final ResolvedBindings resolvedBindings;
    private final FrameworkInstanceCreationExpression frameworkInstanceCreationExpression;
    private FieldSpec fieldSpec;
    private InitializationState fieldInitializationState = InitializationState.UNINITIALIZED;

    FrameworkFieldInitializer(GeneratedComponentModel generatedComponentModel, ResolvedBindings resolvedBindings, FrameworkInstanceCreationExpression frameworkInstanceCreationExpression) {
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.resolvedBindings = (ResolvedBindings)Preconditions.checkNotNull((Object)resolvedBindings);
        this.frameworkInstanceCreationExpression = (FrameworkInstanceCreationExpression)Preconditions.checkNotNull((Object)frameworkInstanceCreationExpression);
    }

    @Override
    public final MemberSelect memberSelect() {
        this.initializeField();
        return MemberSelect.localField(this.generatedComponentModel.name(), ((FieldSpec)Preconditions.checkNotNull((Object)this.fieldSpec)).name);
    }

    private void initializeField() {
        switch (this.fieldInitializationState) {
            case UNINITIALIZED: {
                this.fieldInitializationState = InitializationState.INITIALIZING;
                CodeBlock.Builder codeBuilder = CodeBlock.builder();
                CodeBlock fieldInitialization = this.frameworkInstanceCreationExpression.creationExpression();
                CodeBlock initCode = CodeBlock.of((String)"this.$N = $L;", (Object[])new Object[]{this.getOrCreateField(), fieldInitialization});
                if (this.fieldInitializationState == InitializationState.DELEGATED) {
                    CodeBlock delegateFactoryVariable = CodeBlock.of((String)"$NDelegate", (Object[])new Object[]{this.fieldSpec});
                    codeBuilder.add("$1T $2L = ($1T) $3N;", new Object[]{DelegateFactory.class, delegateFactoryVariable, this.fieldSpec}).add(initCode).add("$L.setDelegatedProvider($N);", new Object[]{delegateFactoryVariable, this.fieldSpec});
                } else {
                    codeBuilder.add(initCode);
                }
                this.generatedComponentModel.addInitialization(codeBuilder.build());
                this.fieldInitializationState = InitializationState.INITIALIZED;
                break;
            }
            case INITIALIZING: {
                this.fieldInitializationState = InitializationState.DELEGATED;
                this.generatedComponentModel.addInitialization(CodeBlock.of((String)"this.$N = new $T<>();", (Object[])new Object[]{this.getOrCreateField(), DelegateFactory.class}));
                break;
            }
            case DELEGATED: 
            case INITIALIZED: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled initialization state: " + (Object)((Object)this.fieldInitializationState)));
            }
        }
    }

    private FieldSpec getOrCreateField() {
        if (this.fieldSpec != null) {
            return this.fieldSpec;
        }
        boolean useRawType = !this.generatedComponentModel.isTypeAccessible(this.resolvedBindings.key().type());
        FrameworkField contributionBindingField = FrameworkField.forResolvedBindings(this.resolvedBindings, this.frameworkInstanceCreationExpression.alternativeFrameworkClass());
        Object fieldType = !this.fieldInitializationState.equals((Object)InitializationState.DELEGATED) && this.specificType().isPresent() ? this.specificType().get() : (useRawType ? contributionBindingField.type().rawType : contributionBindingField.type());
        FieldSpec.Builder contributionField = FieldSpec.builder((TypeName)fieldType, (String)this.generatedComponentModel.getUniqueFieldName(contributionBindingField.name()), (Modifier[])new Modifier[0]);
        contributionField.addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (useRawType && !this.specificType().isPresent()) {
            contributionField.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
        }
        this.fieldSpec = contributionField.build();
        this.generatedComponentModel.addField(GeneratedComponentModel.FieldSpecKind.FRAMEWORK_FIELD, this.fieldSpec);
        return this.fieldSpec;
    }

    @Override
    public Optional<TypeName> specificType() {
        return this.frameworkInstanceCreationExpression.specificType();
    }

    private static enum InitializationState {
        UNINITIALIZED,
        INITIALIZING,
        DELEGATED,
        INITIALIZED;

    }

    static interface FrameworkInstanceCreationExpression {
        public CodeBlock creationExpression();

        default public Optional<TypeName> specificType() {
            return Optional.empty();
        }

        default public Optional<ClassName> alternativeFrameworkClass() {
            return Optional.empty();
        }

        default public boolean isSimpleFactory() {
            return false;
        }
    }
}

