/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import dagger.internal.codegen.DaggerStreams;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.Types;

final class DaggerElements
implements Elements {
    private final Elements elements;
    private final Types types;
    static final ElementVisitor<TypeElement, Void> ENCLOSING_TYPE_ELEMENT = new SimpleElementVisitor6<TypeElement, Void>(){

        @Override
        protected TypeElement defaultAction(Element e, Void p) {
            return (TypeElement)this.visit(e.getEnclosingElement());
        }

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    };

    @Inject
    DaggerElements(Elements elements, Types types) {
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.types = (Types)Preconditions.checkNotNull((Object)types);
    }

    DaggerElements(ProcessingEnvironment processingEnv) {
        this(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
    }

    ImmutableSet<ExecutableElement> getUnimplementedMethods(TypeElement type) {
        return FluentIterable.from(MoreElements.getLocalAndInheritedMethods(type, this.types, this.elements)).filter(MoreElements.hasModifiers(Modifier.ABSTRACT)).toSet();
    }

    TypeElement getTypeElement(Class<?> clazz) {
        return this.getTypeElement(clazz.getCanonicalName());
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        return this.elements.getTypeElement(name);
    }

    static boolean isAnyAnnotationPresent(Element element, Iterable<? extends Class<? extends Annotation>> annotationClasses) {
        for (Class<? extends Annotation> clazz : annotationClasses) {
            if (!MoreElements.isAnnotationPresent(element, clazz)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    static boolean isAnyAnnotationPresent(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... otherAnnotations) {
        return DaggerElements.isAnyAnnotationPresent(element, Lists.asList(first, (Object[])otherAnnotations));
    }

    static boolean isAnnotationPresent(Element element, TypeMirror annotationType) {
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).anyMatch(candidate -> MoreTypes.equivalence().equivalent(candidate, (Object)annotationType));
    }

    @SafeVarargs
    static Optional<AnnotationMirror> getAnyAnnotation(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... rest) {
        return DaggerElements.getAnyAnnotation(element, Lists.asList(first, (Object[])rest));
    }

    static Optional<AnnotationMirror> getAnyAnnotation(Element element, Collection<? extends Class<? extends Annotation>> annotations) {
        return element.getAnnotationMirrors().stream().filter(DaggerElements.hasAnnotationTypeIn(annotations)).map(a -> a).findFirst();
    }

    @SafeVarargs
    static ImmutableSet<AnnotationMirror> getAllAnnotations(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... rest) {
        return element.getAnnotationMirrors().stream().filter(DaggerElements.hasAnnotationTypeIn(Lists.asList(first, (Object[])rest))).collect(DaggerStreams.toImmutableSet());
    }

    static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return Optional.ofNullable((AnnotationMirror)MoreElements.getAnnotationMirror(element, annotationClass).orNull());
    }

    private static Predicate<AnnotationMirror> hasAnnotationTypeIn(Collection<? extends Class<? extends Annotation>> annotations) {
        Set annotationClassNames = annotations.stream().map(Class::getCanonicalName).collect(Collectors.toSet());
        return annotation -> annotationClassNames.contains(MoreTypes.asTypeElement(annotation.getAnnotationType()).getQualifiedName().toString());
    }

    static ImmutableSet<String> suppressedWarnings(Element element) {
        SuppressWarnings suppressedWarnings = element.getAnnotation(SuppressWarnings.class);
        if (suppressedWarnings == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Object[])suppressedWarnings.value());
    }

    TypeElement checkTypePresent(String typeName) {
        TypeElement type = this.elements.getTypeElement(typeName);
        if (type == null) {
            throw new TypeNotPresentException(typeName, null);
        }
        return type;
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        return this.elements.getPackageElement(name);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return this.elements.getElementValuesWithDefaults(a);
    }

    @Override
    public String getDocComment(Element e) {
        return this.elements.getDocComment(e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        return this.elements.isDeprecated(e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return this.elements.getBinaryName(type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        return this.elements.getPackageOf(type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        return this.elements.getAllMembers(type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.elements.getAllAnnotationMirrors(e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        return this.elements.hides(hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        return this.elements.overrides(overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return this.elements.getConstantExpression(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        this.elements.printElements(w, elements);
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.elements.getName(cs);
    }

    @Override
    public boolean isFunctionalInterface(TypeElement type) {
        return this.elements.isFunctionalInterface(type);
    }
}

