/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MultibindingAnnotations;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

abstract class BindingMethodValidator {
    private final DaggerElements elements;
    private final Types types;
    private final Class<? extends Annotation> methodAnnotation;
    private final ImmutableSet<? extends Class<? extends Annotation>> enclosingElementAnnotations;
    private final Abstractness abstractness;
    private final ExceptionSuperclass exceptionSuperclass;
    private final Map<ExecutableElement, ValidationReport<ExecutableElement>> cache = new HashMap<ExecutableElement, ValidationReport<ExecutableElement>>();
    private final AllowsMultibindings allowsMultibindings;

    protected BindingMethodValidator(DaggerElements elements, Types types, Class<? extends Annotation> methodAnnotation, Class<? extends Annotation> enclosingElementAnnotation, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, AllowsMultibindings allowsMultibindings) {
        this(elements, types, methodAnnotation, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(enclosingElementAnnotation), abstractness, exceptionSuperclass, allowsMultibindings);
    }

    protected BindingMethodValidator(DaggerElements elements, Types types, Class<? extends Annotation> methodAnnotation, Iterable<? extends Class<? extends Annotation>> enclosingElementAnnotations, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, AllowsMultibindings allowsMultibindings) {
        this.elements = elements;
        this.types = types;
        this.methodAnnotation = methodAnnotation;
        this.enclosingElementAnnotations = ImmutableSet.copyOf(enclosingElementAnnotations);
        this.abstractness = abstractness;
        this.exceptionSuperclass = exceptionSuperclass;
        this.allowsMultibindings = allowsMultibindings;
    }

    Class<? extends Annotation> methodAnnotation() {
        return this.methodAnnotation;
    }

    final ValidationReport<ExecutableElement> validate(ExecutableElement method) {
        return Util.reentrantComputeIfAbsent(this.cache, method, this::validateUncached);
    }

    private ValidationReport<ExecutableElement> validateUncached(ExecutableElement m) {
        ValidationReport.Builder<ExecutableElement> report = ValidationReport.about(m);
        this.checkMethod(report);
        return report.build();
    }

    @OverridingMethodsMustInvokeSuper
    protected void checkMethod(ValidationReport.Builder<ExecutableElement> builder) {
        this.checkEnclosingElement(builder);
        this.checkTypeParameters(builder);
        this.checkNotPrivate(builder);
        this.checkAbstractness(builder);
        this.checkReturnType(builder);
        this.checkThrows(builder);
        this.checkQualifiers(builder);
        this.checkMapKeys(builder);
        this.checkMultibindings(builder);
    }

    private void checkEnclosingElement(ValidationReport.Builder<ExecutableElement> builder) {
        if (!DaggerElements.isAnyAnnotationPresent(builder.getSubject().getEnclosingElement(), this.enclosingElementAnnotations)) {
            builder.addError(this.formatErrorMessage("@%s methods can only be present within a @%s", FluentIterable.from(this.enclosingElementAnnotations).transform(Class::getSimpleName).join(Joiner.on((String)" or @"))));
        }
    }

    private void checkTypeParameters(ValidationReport.Builder<ExecutableElement> builder) {
        if (!builder.getSubject().getTypeParameters().isEmpty()) {
            builder.addError(this.formatErrorMessage("@%s methods may not have type parameters.", new Object[0]));
        }
    }

    private void checkNotPrivate(ValidationReport.Builder<ExecutableElement> builder) {
        if (builder.getSubject().getModifiers().contains((Object)Modifier.PRIVATE)) {
            builder.addError(this.formatErrorMessage("@%s methods cannot be private", new Object[0]));
        }
    }

    private void checkAbstractness(ValidationReport.Builder<ExecutableElement> builder) {
        boolean isAbstract = builder.getSubject().getModifiers().contains((Object)Modifier.ABSTRACT);
        switch (this.abstractness) {
            case MUST_BE_ABSTRACT: {
                if (isAbstract) break;
                builder.addError(this.formatErrorMessage("@%s methods must be abstract", new Object[0]));
                break;
            }
            case MUST_BE_CONCRETE: {
                if (!isAbstract) break;
                builder.addError(this.formatErrorMessage("@%s methods cannot be abstract", new Object[0]));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    protected void checkReturnType(ValidationReport.Builder<ExecutableElement> builder) {
        switch (ContributionType.fromBindingMethod(builder.getSubject())) {
            case UNIQUE: {
                this.checkFrameworkType(builder);
            }
            case SET: 
            case MAP: {
                this.checkKeyType(builder, builder.getSubject().getReturnType());
                break;
            }
            case SET_VALUES: {
                this.checkSetValuesType(builder);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    protected void checkKeyType(ValidationReport.Builder<ExecutableElement> builder, TypeMirror keyType) {
        TypeKind kind = keyType.getKind();
        if (kind.equals((Object)TypeKind.VOID)) {
            builder.addError(this.formatErrorMessage("@%s methods must return a value (not void).", new Object[0]));
        } else if (!(kind.isPrimitive() || kind.equals((Object)TypeKind.DECLARED) || kind.equals((Object)TypeKind.ARRAY) || kind.equals((Object)TypeKind.TYPEVAR))) {
            builder.addError(this.badReturnTypeMessage());
        }
    }

    protected String badReturnTypeMessage() {
        return this.formatErrorMessage("@%s methods must return a primitive, an array, a type variable, or a declared type.", new Object[0]);
    }

    protected void checkSetValuesType(ValidationReport.Builder<ExecutableElement> builder) {
        this.checkSetValuesType(builder, builder.getSubject().getReturnType());
    }

    protected final void checkSetValuesType(ValidationReport.Builder<ExecutableElement> builder, TypeMirror type) {
        if (!SetType.isSet(type)) {
            builder.addError(this.badSetValuesTypeMessage());
        } else {
            SetType setType = SetType.from(type);
            if (setType.isRawType()) {
                builder.addError(this.formatErrorMessage("@%s methods of type set values cannot return a raw Set", new Object[0]));
            } else {
                this.checkKeyType(builder, setType.elementType());
            }
        }
    }

    private void checkThrows(ValidationReport.Builder<ExecutableElement> builder) {
        this.exceptionSuperclass.checkThrows(this, builder);
    }

    protected void checkQualifiers(ValidationReport.Builder<ExecutableElement> builder) {
        ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(builder.getSubject());
        if (qualifiers.size() > 1) {
            for (AnnotationMirror qualifier : qualifiers) {
                builder.addError("Cannot use more than one @Qualifier", builder.getSubject(), qualifier);
            }
        }
    }

    protected void checkMapKeys(ValidationReport.Builder<ExecutableElement> builder) {
        if (!this.allowsMultibindings.allowsMultibindings()) {
            return;
        }
        ImmutableSet<? extends AnnotationMirror> mapKeys = MapKeys.getMapKeys(builder.getSubject());
        if (ContributionType.fromBindingMethod(builder.getSubject()).equals((Object)ContributionType.MAP)) {
            switch (mapKeys.size()) {
                case 0: {
                    builder.addError(this.formatErrorMessage("@%s methods of type map must declare a map key", new Object[0]));
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    builder.addError(this.formatErrorMessage("@%s methods may not have more than one @MapKey-marked annotation", new Object[0]));
                    break;
                }
            }
        } else if (!mapKeys.isEmpty()) {
            builder.addError(this.formatErrorMessage("@%s methods of non map type cannot declare a map key", new Object[0]));
        }
    }

    protected void checkMultibindings(ValidationReport.Builder<ExecutableElement> builder) {
        if (!this.allowsMultibindings.allowsMultibindings()) {
            return;
        }
        ImmutableSet<AnnotationMirror> multibindingAnnotations = MultibindingAnnotations.forMethod(builder.getSubject());
        if (multibindingAnnotations.size() > 1) {
            for (AnnotationMirror annotation : multibindingAnnotations) {
                builder.addError(this.formatErrorMessage("Multiple multibinding annotations cannot be placed on the same %s method", new Object[0]), builder.getSubject(), annotation);
            }
        }
        AnnotationMirror bindingAnnotationMirror = DaggerElements.getAnnotationMirror(builder.getSubject(), this.methodAnnotation).get();
        boolean usesProvidesType = false;
        for (ExecutableElement member : bindingAnnotationMirror.getElementValues().keySet()) {
            usesProvidesType |= member.getSimpleName().contentEquals("type");
        }
        if (usesProvidesType && !multibindingAnnotations.isEmpty()) {
            builder.addError(this.formatErrorMessage("@%s.type cannot be used with multibinding annotations", new Object[0]), builder.getSubject());
        }
    }

    protected void checkFrameworkType(ValidationReport.Builder<ExecutableElement> builder) {
        if (FrameworkTypes.isFrameworkType(builder.getSubject().getReturnType())) {
            builder.addError(this.formatErrorMessage("@%s methods must not return framework types.", new Object[0]));
        }
    }

    protected String formatErrorMessage(String format, Object ... otherParameters) {
        return otherParameters.length == 0 ? String.format(format, this.methodAnnotation.getSimpleName()) : String.format(format, Lists.asList((Object)this.methodAnnotation.getSimpleName(), (Object[])otherParameters).toArray());
    }

    protected String badSetValuesTypeMessage() {
        return this.formatErrorMessage("@%s methods of type set values must return a Set", new Object[0]);
    }

    protected static enum AllowsMultibindings {
        NO_MULTIBINDINGS,
        ALLOWS_MULTIBINDINGS;


        private boolean allowsMultibindings() {
            return this == ALLOWS_MULTIBINDINGS;
        }
    }

    protected static enum ExceptionSuperclass {
        NO_EXCEPTIONS{

            @Override
            protected void checkThrows(BindingMethodValidator validator, ValidationReport.Builder<ExecutableElement> builder) {
                if (!builder.getSubject().getThrownTypes().isEmpty()) {
                    builder.addError(validator.formatErrorMessage("@%s methods may not throw", new Object[0]));
                    return;
                }
            }
        }
        ,
        EXCEPTION(Exception.class, "@%s methods may only throw unchecked exceptions or exceptions subclassing Exception"),
        RUNTIME_EXCEPTION(RuntimeException.class, "@%s methods may only throw unchecked exceptions");

        private final Class<? extends Exception> superclass;
        private final String errorMessage;

        private ExceptionSuperclass() {
            this(null, null);
        }

        private ExceptionSuperclass(Class<? extends Exception> superclass, String errorMessage) {
            this.superclass = superclass;
            this.errorMessage = errorMessage;
        }

        protected void checkThrows(BindingMethodValidator validator, ValidationReport.Builder<ExecutableElement> builder) {
            TypeMirror exceptionSupertype = validator.elements.getTypeElement(this.superclass.getCanonicalName()).asType();
            TypeMirror errorType = validator.elements.getTypeElement(Error.class).asType();
            for (TypeMirror typeMirror : builder.getSubject().getThrownTypes()) {
                if (validator.types.isSubtype(typeMirror, exceptionSupertype) || validator.types.isSubtype(typeMirror, errorType)) continue;
                builder.addError(validator.formatErrorMessage(this.errorMessage, new Object[0]));
                break;
            }
        }
    }

    protected static enum Abstractness {
        MUST_BE_ABSTRACT,
        MUST_BE_CONCRETE;

    }
}

