/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import dagger.MembersInjector;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingFactory;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.RequestKinds;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.internal.codegen.Util;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.Scope;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class BindingGraphFactory {
    private final DaggerElements elements;
    private final InjectBindingRegistry injectBindingRegistry;
    private final KeyFactory keyFactory;
    private final BindingFactory bindingFactory;

    @Inject
    BindingGraphFactory(DaggerElements elements, InjectBindingRegistry injectBindingRegistry, KeyFactory keyFactory, BindingFactory bindingFactory) {
        this.elements = elements;
        this.injectBindingRegistry = injectBindingRegistry;
        this.keyFactory = keyFactory;
        this.bindingFactory = bindingFactory;
    }

    BindingGraph create(ComponentDescriptor componentDescriptor) {
        Preconditions.checkArgument((boolean)componentDescriptor.kind().isTopLevel());
        return this.create(Optional.empty(), componentDescriptor);
    }

    private BindingGraph create(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor) {
        ImmutableSet.Builder explicitBindingsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder delegatesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder optionalsBuilder = ImmutableSet.builder();
        explicitBindingsBuilder.add((Object)this.bindingFactory.componentBinding(componentDescriptor.componentDefinitionType()));
        for (ComponentRequirement dependency : componentDescriptor.dependencies()) {
            explicitBindingsBuilder.add((Object)this.bindingFactory.componentDependencyBinding(dependency));
            List<ExecutableElement> dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(dependency.typeElement()));
            for (ExecutableElement method : dependencyMethods) {
                if (!ComponentDescriptor.isComponentContributionMethod(this.elements, method)) continue;
                explicitBindingsBuilder.add((Object)this.bindingFactory.componentDependencyMethodBinding(componentDescriptor, method));
            }
        }
        if (componentDescriptor.builderSpec().isPresent()) {
            for (ComponentDescriptor.BuilderRequirementMethod method : componentDescriptor.builderSpec().get().requirementMethods()) {
                if (!method.requirement().kind().equals((Object)ComponentRequirement.Kind.BOUND_INSTANCE)) continue;
                explicitBindingsBuilder.add((Object)this.bindingFactory.boundInstanceBinding(method));
            }
        }
        for (Map.Entry componentMethodAndSubcomponent : componentDescriptor.subcomponentsByBuilderMethod().entrySet()) {
            ComponentDescriptor.ComponentMethodDescriptor componentMethod = (ComponentDescriptor.ComponentMethodDescriptor)componentMethodAndSubcomponent.getKey();
            ComponentDescriptor subcomponentDescriptor = (ComponentDescriptor)componentMethodAndSubcomponent.getValue();
            if (componentDescriptor.subcomponentsFromModules().contains((Object)subcomponentDescriptor)) continue;
            explicitBindingsBuilder.add((Object)this.bindingFactory.subcomponentBuilderBinding(componentMethod.methodElement(), componentDescriptor.componentDefinitionType()));
        }
        ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
        ImmutableSet.Builder subcomponentDeclarations = ImmutableSet.builder();
        for (ModuleDescriptor moduleDescriptor : componentDescriptor.transitiveModules()) {
            explicitBindingsBuilder.addAll(moduleDescriptor.bindings());
            multibindingDeclarations.addAll(moduleDescriptor.multibindingDeclarations());
            subcomponentDeclarations.addAll(moduleDescriptor.subcomponentDeclarations());
            delegatesBuilder.addAll(moduleDescriptor.delegateDeclarations());
            optionalsBuilder.addAll(moduleDescriptor.optionalDeclarations());
        }
        ImmutableSetMultimap<Scope, ProvisionBinding> releasableReferenceManagerBindings = this.getReleasableReferenceManagerBindings(componentDescriptor);
        explicitBindingsBuilder.addAll((Iterable)releasableReferenceManagerBindings.values());
        Resolver requestResolver = new Resolver(parentResolver, componentDescriptor, BindingGraphFactory.indexBindingDeclarationsByKey(explicitBindingsBuilder.build()), BindingGraphFactory.indexBindingDeclarationsByKey(multibindingDeclarations.build()), BindingGraphFactory.indexBindingDeclarationsByKey(subcomponentDeclarations.build()), BindingGraphFactory.indexBindingDeclarationsByKey(delegatesBuilder.build()), BindingGraphFactory.indexBindingDeclarationsByKey(optionalsBuilder.build()));
        for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : componentDescriptor.componentMethods()) {
            if (componentMethod.kind().equals((Object)ComponentDescriptor.ComponentMethodKind.MEMBERS_INJECTION)) {
                requestResolver.resolveMembersInjectionMethod(componentMethod);
                continue;
            }
            Optional<DependencyRequest> componentMethodRequest = componentMethod.dependencyRequest();
            if (!componentMethodRequest.isPresent()) continue;
            requestResolver.resolve(((DependencyRequest)componentMethodRequest.get()).key());
        }
        HashSet<ComponentDescriptor> resolvedSubcomponents = new HashSet<ComponentDescriptor>();
        ImmutableSet.Builder subgraphs = ImmutableSet.builder();
        for (ComponentDescriptor subcomponent : Iterables.consumingIterable(requestResolver.subcomponentsToResolve)) {
            if (!resolvedSubcomponents.add(subcomponent)) continue;
            subgraphs.add((Object)this.create(Optional.of(requestResolver), subcomponent));
        }
        ImmutableMap<Key, ResolvedBindings> resolvedContributionBindingsMap = requestResolver.getResolvedContributionBindings();
        for (ResolvedBindings resolvedBindings : resolvedContributionBindingsMap.values()) {
            Verify.verify((boolean)resolvedBindings.owningComponent().equals(componentDescriptor), (String)"%s is not owned by %s", (Object)resolvedBindings, (Object)componentDescriptor);
        }
        return BindingGraph.create(componentDescriptor, resolvedContributionBindingsMap, requestResolver.getResolvedMembersInjectionBindings(), (ImmutableSet<BindingGraph>)subgraphs.build(), this.getScopesRequiringReleasableReferenceManagers(releasableReferenceManagerBindings, (ImmutableSet<Key>)resolvedContributionBindingsMap.keySet()), requestResolver.getOwnedModules(), requestResolver.getFactoryMethod());
    }

    private ImmutableSetMultimap<Scope, ProvisionBinding> getReleasableReferenceManagerBindings(ComponentDescriptor componentDescriptor) {
        ImmutableSetMultimap.Builder bindings = ImmutableSetMultimap.builder();
        for (Scope scope : componentDescriptor.releasableReferencesScopes()) {
            bindings.put((Object)scope, (Object)this.bindingFactory.releasableReferenceManagerBinding(scope));
            bindings.put((Object)scope, (Object)this.bindingFactory.setOfReleasableReferenceManagersBinding());
            for (AnnotationMirror metadata : scope.releasableReferencesMetadata()) {
                bindings.put((Object)scope, (Object)this.bindingFactory.typedReleasableReferenceManagerBinding(scope, metadata.getAnnotationType()));
                bindings.put((Object)scope, (Object)this.bindingFactory.setOfTypedReleasableReferenceManagersBinding(metadata.getAnnotationType()));
            }
        }
        return bindings.build();
    }

    private ImmutableSet<Scope> getScopesRequiringReleasableReferenceManagers(ImmutableSetMultimap<Scope, ProvisionBinding> releasableReferenceManagerBindings, ImmutableSet<Key> resolvedContributionKeys) {
        ImmutableSet.Builder scopes = ImmutableSet.builder();
        releasableReferenceManagerBindings.asMap().forEach((scope, bindings) -> {
            for (Binding binding : bindings) {
                if (!resolvedContributionKeys.contains((Object)binding.key())) continue;
                scopes.add(scope);
                return;
            }
        });
        return scopes.build();
    }

    private static <T extends BindingDeclaration> ImmutableSetMultimap<Key, T> indexBindingDeclarationsByKey(Iterable<T> declarations) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(declarations, BindingDeclaration::key));
    }

    static <T extends BindingDeclaration> ImmutableSetMultimap<Key, T> multibindingContributionsByMultibindingKey(Iterable<T> declarations) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (BindingDeclaration declaration : declarations) {
            if (!declaration.key().multibindingContributionIdentifier().isPresent()) continue;
            builder.put((Object)declaration.key().toBuilder().multibindingContributionIdentifier(Optional.empty()).build(), (Object)declaration);
        }
        return builder.build();
    }

    private final class Resolver {
        final Optional<Resolver> parentResolver;
        final ComponentDescriptor componentDescriptor;
        final ImmutableSetMultimap<Key, ContributionBinding> explicitBindings;
        final ImmutableSet<ContributionBinding> explicitBindingsSet;
        final ImmutableSetMultimap<Key, ContributionBinding> explicitMultibindings;
        final ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations;
        final ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponentDeclarations;
        final ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations;
        final ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindingDeclarations;
        final ImmutableSetMultimap<Key, DelegateDeclaration> delegateMultibindingDeclarations;
        final Map<Key, ResolvedBindings> resolvedContributionBindings = new LinkedHashMap<Key, ResolvedBindings>();
        final Map<Key, ResolvedBindings> resolvedMembersInjectionBindings = new LinkedHashMap<Key, ResolvedBindings>();
        final Deque<Key> cycleStack = new ArrayDeque<Key>();
        final Map<Key, Boolean> keyDependsOnLocalBindingsCache = new HashMap<Key, Boolean>();
        final Map<Binding, Boolean> bindingDependsOnLocalBindingsCache = new HashMap<Binding, Boolean>();
        final Queue<ComponentDescriptor> subcomponentsToResolve = new ArrayDeque<ComponentDescriptor>();

        Resolver(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor, ImmutableSetMultimap<Key, ContributionBinding> explicitBindings, ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations, ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponentDeclarations, ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations, ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindingDeclarations) {
            this.parentResolver = (Optional)Preconditions.checkNotNull(parentResolver);
            this.componentDescriptor = (ComponentDescriptor)Preconditions.checkNotNull((Object)componentDescriptor);
            this.explicitBindings = (ImmutableSetMultimap)Preconditions.checkNotNull(explicitBindings);
            this.explicitBindingsSet = ImmutableSet.copyOf((Collection)explicitBindings.values());
            this.multibindingDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(multibindingDeclarations);
            this.subcomponentDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(subcomponentDeclarations);
            this.delegateDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(delegateDeclarations);
            this.optionalBindingDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(optionalBindingDeclarations);
            this.explicitMultibindings = BindingGraphFactory.multibindingContributionsByMultibindingKey(this.explicitBindingsSet);
            this.delegateMultibindingDeclarations = BindingGraphFactory.multibindingContributionsByMultibindingKey(delegateDeclarations.values());
            this.subcomponentsToResolve.addAll((Collection<ComponentDescriptor>)componentDescriptor.subcomponentsFromEntryPoints());
        }

        Optional<ExecutableElement> getFactoryMethod() {
            return this.parentResolver.map(parent -> (ComponentDescriptor.ComponentMethodDescriptor)parent.componentDescriptor.subcomponentsByFactoryMethod().inverse().get((Object)this.componentDescriptor)).map(method -> method.methodElement());
        }

        ResolvedBindings lookUpBindings(Key requestKey) {
            LinkedHashSet<ContributionBinding> bindings = new LinkedHashSet<ContributionBinding>();
            bindings.addAll((Collection<ContributionBinding>)this.getExplicitBindings(requestKey));
            ImmutableSet multibindingContributions = this.getAllMatchingBindingDeclarations(requestKey, this::getExplicitMultibindings);
            ImmutableSet multibindingDeclarations = this.getAllMatchingBindingDeclarations(requestKey, this::getMultibindingDeclarations);
            this.syntheticMultibinding(requestKey, (Iterable<ContributionBinding>)multibindingContributions, (Iterable<MultibindingDeclaration>)multibindingDeclarations).ifPresent(bindings::add);
            ImmutableSet optionalBindingDeclarations = this.getAllMatchingBindingDeclarations(requestKey, this::getOptionalBindingDeclarations);
            this.syntheticOptionalBinding(requestKey, optionalBindingDeclarations).ifPresent(bindings::add);
            ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations = this.getSubcomponentDeclarations(requestKey);
            this.syntheticSubcomponentBuilderBinding(subcomponentDeclarations).ifPresent(binding -> {
                bindings.add((ContributionBinding)binding);
                this.addSubcomponentToOwningResolver((ProvisionBinding)binding);
            });
            if (MoreTypes.isType(requestKey.type()) && MoreTypes.isTypeOf(MembersInjector.class, requestKey.type())) {
                BindingGraphFactory.this.injectBindingRegistry.getOrFindMembersInjectorProvisionBinding(requestKey).ifPresent(bindings::add);
            }
            if (bindings.isEmpty()) {
                BindingGraphFactory.this.injectBindingRegistry.getOrFindProvisionBinding(requestKey).ifPresent(bindings::add);
            }
            return ResolvedBindings.forContributionBindings(requestKey, this.componentDescriptor, this.indexBindingsByOwningComponent(requestKey, (Iterable<? extends ContributionBinding>)ImmutableSet.copyOf(bindings)), multibindingDeclarations, subcomponentDeclarations, optionalBindingDeclarations);
        }

        ResolvedBindings lookUpMembersInjectionBinding(Key requestKey) {
            Optional<MembersInjectionBinding> binding = BindingGraphFactory.this.injectBindingRegistry.getOrFindMembersInjectionBinding(requestKey);
            return binding.isPresent() ? ResolvedBindings.forMembersInjectionBinding(requestKey, this.componentDescriptor, binding.get()) : ResolvedBindings.noBindings(requestKey, this.componentDescriptor);
        }

        private void addSubcomponentToOwningResolver(ProvisionBinding subcomponentBuilderBinding) {
            Preconditions.checkArgument((boolean)subcomponentBuilderBinding.kind().equals((Object)BindingKind.SUBCOMPONENT_BUILDER));
            Resolver owningResolver = this.getOwningResolver(subcomponentBuilderBinding).get();
            TypeElement builderType = MoreTypes.asTypeElement(subcomponentBuilderBinding.key().type());
            owningResolver.subcomponentsToResolve.add((ComponentDescriptor)owningResolver.componentDescriptor.subcomponentsByBuilderType().get((Object)builderType));
        }

        private ImmutableSet<Key> keysMatchingRequest(Key requestKey) {
            ImmutableSet.Builder keys = ImmutableSet.builder();
            keys.add((Object)requestKey);
            BindingGraphFactory.this.keyFactory.unwrapSetKey(requestKey, Produced.class).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
            BindingGraphFactory.this.keyFactory.rewrapMapKey(requestKey, Producer.class, Provider.class).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
            BindingGraphFactory.this.keyFactory.rewrapMapKey(requestKey, Provider.class, Producer.class).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
            keys.addAll(BindingGraphFactory.this.keyFactory.implicitFrameworkMapKeys(requestKey));
            return keys.build();
        }

        private Optional<ContributionBinding> syntheticMultibinding(Key key, Iterable<ContributionBinding> multibindingContributions, Iterable<MultibindingDeclaration> multibindingDeclarations) {
            return Iterables.isEmpty(multibindingContributions) && Iterables.isEmpty(multibindingDeclarations) ? Optional.empty() : Optional.of(BindingGraphFactory.this.bindingFactory.syntheticMultibinding(key, multibindingContributions));
        }

        private Optional<ProvisionBinding> syntheticSubcomponentBuilderBinding(ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
            return subcomponentDeclarations.isEmpty() ? Optional.empty() : Optional.of(BindingGraphFactory.this.bindingFactory.subcomponentBuilderBinding(subcomponentDeclarations));
        }

        private Optional<ContributionBinding> syntheticOptionalBinding(Key key, ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations) {
            return optionalBindingDeclarations.isEmpty() ? Optional.empty() : Optional.of(BindingGraphFactory.this.bindingFactory.syntheticOptionalBinding(key, RequestKinds.getRequestKind(OptionalType.from(key).valueType()), this.lookUpBindings(BindingGraphFactory.this.keyFactory.unwrapOptional(key).get())));
        }

        private ImmutableSet<ContributionBinding> createDelegateBindings(ImmutableSet<DelegateDeclaration> delegateDeclarations) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (DelegateDeclaration delegateDeclaration : delegateDeclarations) {
                builder.add((Object)this.createDelegateBinding(delegateDeclaration));
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ContributionBinding createDelegateBinding(DelegateDeclaration delegateDeclaration) {
            ResolvedBindings resolvedDelegate;
            Key delegateKey = delegateDeclaration.delegateRequest().key();
            if (this.cycleStack.contains(delegateKey)) {
                return BindingGraphFactory.this.bindingFactory.missingDelegateBinding(delegateDeclaration);
            }
            try {
                this.cycleStack.push(delegateKey);
                resolvedDelegate = this.lookUpBindings(delegateKey);
            }
            finally {
                this.cycleStack.pop();
            }
            if (resolvedDelegate.contributionBindings().isEmpty()) {
                return BindingGraphFactory.this.bindingFactory.missingDelegateBinding(delegateDeclaration);
            }
            ContributionBinding explicitDelegate = (ContributionBinding)resolvedDelegate.contributionBindings().iterator().next();
            return BindingGraphFactory.this.bindingFactory.delegateBinding(delegateDeclaration, explicitDelegate);
        }

        private ImmutableSetMultimap<ComponentDescriptor, ContributionBinding> indexBindingsByOwningComponent(Key requestKey, Iterable<? extends ContributionBinding> bindings) {
            ImmutableSetMultimap.Builder index = ImmutableSetMultimap.builder();
            for (ContributionBinding contributionBinding : bindings) {
                index.put((Object)this.getOwningComponent(requestKey, contributionBinding), (Object)contributionBinding);
            }
            return index.build();
        }

        private ComponentDescriptor getOwningComponent(Key requestKey, ContributionBinding binding) {
            if (this.isResolvedInParent(requestKey, binding) && !new LocalDependencyChecker().dependsOnLocalBindings(binding)) {
                ResolvedBindings parentResolvedBindings = this.parentResolver.get().resolvedContributionBindings.get(requestKey);
                return parentResolvedBindings.owningComponent(binding);
            }
            return this.componentDescriptor;
        }

        private boolean isResolvedInParent(Key requestKey, ContributionBinding binding) {
            Optional<Resolver> owningResolver = this.getOwningResolver(binding);
            if (owningResolver.isPresent() && !owningResolver.get().equals(this)) {
                this.parentResolver.get().resolve(requestKey);
                return true;
            }
            return false;
        }

        private Optional<Resolver> getOwningResolver(ContributionBinding binding) {
            if (binding.scope().isPresent() && binding.scope().get().isReusable()) {
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!requestResolver.resolvedContributionBindings.containsKey(binding.key())) continue;
                    return Optional.of(requestResolver);
                }
                return Optional.empty();
            }
            for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                if (!requestResolver.explicitBindingsSet.contains((Object)binding) && !requestResolver.subcomponentDeclarations.containsKey((Object)binding.key())) continue;
                return Optional.of(requestResolver);
            }
            Optional<Scope> bindingScope = binding.scope();
            if (bindingScope.isPresent()) {
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!requestResolver.componentDescriptor.scopes().contains((Object)bindingScope.get())) continue;
                    return Optional.of(requestResolver);
                }
            }
            return Optional.empty();
        }

        private ImmutableList<Resolver> getResolverLineage() {
            ArrayList resolverList = Lists.newArrayList();
            Optional<Resolver> currentResolver = Optional.of(this);
            while (currentResolver.isPresent()) {
                resolverList.add(currentResolver.get());
                currentResolver = currentResolver.get().parentResolver;
            }
            return ImmutableList.copyOf((Collection)Lists.reverse((List)resolverList));
        }

        private <T extends BindingDeclaration> ImmutableSet<T> getAllMatchingBindingDeclarations(Key requestKey, Function<Key, Collection<T>> getDeclarationsPerKey) {
            return this.keysMatchingRequest(requestKey).stream().flatMap(key -> ((Collection)getDeclarationsPerKey.apply((Key)key)).stream()).collect(DaggerStreams.toImmutableSet());
        }

        private ImmutableSet<ContributionBinding> getExplicitBindings(Key key) {
            ImmutableSet.Builder bindings = ImmutableSet.builder();
            for (Resolver resolver : this.getResolverLineage()) {
                bindings.addAll(resolver.getLocalExplicitBindings(key));
            }
            return bindings.build();
        }

        private ImmutableSet<ContributionBinding> getLocalExplicitBindings(Key key) {
            return new ImmutableSet.Builder().addAll((Iterable)this.explicitBindings.get((Object)key)).addAll(this.createDelegateBindings((ImmutableSet<DelegateDeclaration>)this.delegateDeclarations.get((Object)BindingGraphFactory.this.keyFactory.convertToDelegateKey(key)))).build();
        }

        private ImmutableSet<ContributionBinding> getExplicitMultibindings(Key key) {
            ImmutableSet.Builder multibindings = ImmutableSet.builder();
            for (Resolver resolver : this.getResolverLineage()) {
                multibindings.addAll(resolver.getLocalExplicitMultibindings(key));
            }
            return multibindings.build();
        }

        private ImmutableSet<ContributionBinding> getLocalExplicitMultibindings(Key key) {
            ImmutableSet.Builder multibindings = ImmutableSet.builder();
            multibindings.addAll((Iterable)this.explicitMultibindings.get((Object)key));
            if (!MapType.isMap(key) || MapType.from(key).isRawType() || MapType.from(key).valuesAreFrameworkType()) {
                multibindings.addAll(this.createDelegateBindings((ImmutableSet<DelegateDeclaration>)this.delegateMultibindingDeclarations.get((Object)BindingGraphFactory.this.keyFactory.convertToDelegateKey(key))));
            }
            return multibindings.build();
        }

        private ImmutableSet<MultibindingDeclaration> getMultibindingDeclarations(Key key) {
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            for (Resolver resolver : this.getResolverLineage()) {
                multibindingDeclarations.addAll((Iterable)resolver.multibindingDeclarations.get((Object)key));
            }
            return multibindingDeclarations.build();
        }

        private ImmutableSet<SubcomponentDeclaration> getSubcomponentDeclarations(Key key) {
            ImmutableSet.Builder subcomponentDeclarations = ImmutableSet.builder();
            for (Resolver resolver : this.getResolverLineage()) {
                subcomponentDeclarations.addAll((Iterable)resolver.subcomponentDeclarations.get((Object)key));
            }
            return subcomponentDeclarations.build();
        }

        private ImmutableSet<OptionalBindingDeclaration> getOptionalBindingDeclarations(Key key) {
            Optional<Key> unwrapped = BindingGraphFactory.this.keyFactory.unwrapOptional(key);
            if (!unwrapped.isPresent()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder declarations = ImmutableSet.builder();
            for (Resolver resolver : this.getResolverLineage()) {
                declarations.addAll((Iterable)resolver.optionalBindingDeclarations.get((Object)unwrapped.get()));
            }
            return declarations.build();
        }

        private Optional<ResolvedBindings> getPreviouslyResolvedBindings(Key key) {
            Optional<ResolvedBindings> result = Optional.ofNullable(this.resolvedContributionBindings.get(key));
            if (result.isPresent()) {
                return result;
            }
            if (this.parentResolver.isPresent()) {
                return this.parentResolver.get().getPreviouslyResolvedBindings(key);
            }
            return Optional.empty();
        }

        private void resolveMembersInjectionMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
            Preconditions.checkArgument((boolean)componentMethod.kind().equals((Object)ComponentDescriptor.ComponentMethodKind.MEMBERS_INJECTION));
            Key key = componentMethod.dependencyRequest().get().key();
            ResolvedBindings bindings = this.lookUpMembersInjectionBinding(key);
            this.resolveDependencies(bindings);
            this.resolvedMembersInjectionBindings.put(key, bindings);
        }

        void resolve(Key key) {
            if (this.cycleStack.contains(key)) {
                return;
            }
            if (this.resolvedContributionBindings.containsKey(key)) {
                return;
            }
            if (this.getPreviouslyResolvedBindings(key).isPresent()) {
                this.parentResolver.get().resolve(key);
                if (!new LocalDependencyChecker().dependsOnLocalBindings(key) && this.getLocalExplicitBindings(key).isEmpty()) {
                    ResolvedBindings inheritedBindings = this.getPreviouslyResolvedBindings(key).get().asInheritedIn(this.componentDescriptor);
                    this.resolvedContributionBindings.put(key, inheritedBindings);
                    return;
                }
            }
            this.cycleStack.push(key);
            try {
                ResolvedBindings bindings = this.lookUpBindings(key);
                this.resolveDependencies(bindings);
                this.resolvedContributionBindings.put(key, bindings);
            }
            finally {
                this.cycleStack.pop();
            }
        }

        private void resolveDependencies(ResolvedBindings resolvedBindings) {
            for (Binding binding : resolvedBindings.ownedBindings()) {
                for (DependencyRequest dependency : binding.dependencies()) {
                    this.resolve(dependency.key());
                }
            }
        }

        ImmutableMap<Key, ResolvedBindings> getResolvedContributionBindings() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll(this.resolvedContributionBindings);
            if (this.parentResolver.isPresent()) {
                ImmutableMap<Key, ResolvedBindings> parentBindings = this.parentResolver.get().getResolvedContributionBindings();
                Collection bindingsResolvedInParent = Maps.difference(parentBindings, this.resolvedContributionBindings).entriesOnlyOnLeft().values();
                for (ResolvedBindings resolvedInParent : bindingsResolvedInParent) {
                    builder.put((Object)resolvedInParent.key(), (Object)resolvedInParent.asInheritedIn(this.componentDescriptor));
                }
            }
            return builder.build();
        }

        ImmutableMap<Key, ResolvedBindings> getResolvedMembersInjectionBindings() {
            return ImmutableMap.copyOf(this.resolvedMembersInjectionBindings);
        }

        ImmutableSet<ModuleDescriptor> getInheritedModules() {
            return this.parentResolver.isPresent() ? Sets.union(this.parentResolver.get().getInheritedModules(), this.parentResolver.get().componentDescriptor.transitiveModules()).immutableCopy() : ImmutableSet.of();
        }

        ImmutableSet<ModuleDescriptor> getOwnedModules() {
            return Sets.difference(this.componentDescriptor.transitiveModules(), this.getInheritedModules()).immutableCopy();
        }

        private final class LocalDependencyChecker {
            private final Set<Object> cycleChecker = new HashSet<Object>();

            private LocalDependencyChecker() {
            }

            boolean dependsOnLocalBindings(Key key) {
                if (!this.cycleChecker.add(key)) {
                    return false;
                }
                return Util.reentrantComputeIfAbsent(Resolver.this.keyDependsOnLocalBindingsCache, key, this::dependsOnLocalBindingsUncached);
            }

            private boolean dependsOnLocalBindingsUncached(Key key) {
                Preconditions.checkArgument((boolean)Resolver.this.getPreviouslyResolvedBindings(key).isPresent(), (String)"no previously resolved bindings in %s for %s", (Object)Resolver.this, (Object)key);
                ResolvedBindings previouslyResolvedBindings = (ResolvedBindings)Resolver.this.getPreviouslyResolvedBindings(key).get();
                if (this.hasLocalMultibindingContributions(key) || this.hasLocalOptionalBindingContribution(previouslyResolvedBindings)) {
                    return true;
                }
                for (Binding binding : previouslyResolvedBindings.bindings()) {
                    if (!this.dependsOnLocalBindings(binding)) continue;
                    return true;
                }
                return false;
            }

            boolean dependsOnLocalBindings(Binding binding) {
                if (!this.cycleChecker.add(binding)) {
                    return false;
                }
                return Util.reentrantComputeIfAbsent(Resolver.this.bindingDependsOnLocalBindingsCache, binding, this::dependsOnLocalBindingsUncached);
            }

            private boolean dependsOnLocalBindingsUncached(Binding binding) {
                if (!(binding.scope().isPresent() && !binding.scope().get().isReusable() || binding.bindingType().equals((Object)BindingType.PRODUCTION))) {
                    for (DependencyRequest dependency : binding.dependencies()) {
                        if (!this.dependsOnLocalBindings(dependency.key())) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean hasLocalMultibindingContributions(Key requestKey) {
                return Resolver.this.keysMatchingRequest(requestKey).stream().anyMatch(key -> !Resolver.this.getLocalExplicitMultibindings(key).isEmpty());
            }

            private boolean hasLocalOptionalBindingContribution(ResolvedBindings resolvedBindings) {
                if (resolvedBindings.contributionBindings().stream().map(dagger.model.Binding::kind).anyMatch(Predicate.isEqual(BindingKind.OPTIONAL))) {
                    return !Resolver.this.getLocalExplicitBindings(BindingGraphFactory.this.keyFactory.unwrapOptional(resolvedBindings.key()).get()).isEmpty();
                }
                return !Resolver.this.getOptionalBindingDeclarations(resolvedBindings.key()).isEmpty();
            }
        }
    }
}

