/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import dagger.internal.codegen.AutoValue_ResolvedBindings;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.Keys;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.model.Key;
import dagger.model.Scope;
import java.util.Collection;
import java.util.Optional;

abstract class ResolvedBindings
implements BindingType.HasBindingType,
ContributionType.HasContributionType,
Keys.HasKey {
    ResolvedBindings() {
    }

    abstract BindingKey bindingKey();

    abstract ComponentDescriptor owningComponent();

    abstract ImmutableSetMultimap<ComponentDescriptor, ContributionBinding> allContributionBindings();

    abstract ImmutableMap<ComponentDescriptor, MembersInjectionBinding> allMembersInjectionBindings();

    @Override
    public Key key() {
        return this.bindingKey().key();
    }

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    abstract ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations();

    private ImmutableSetMultimap<ComponentDescriptor, ? extends Binding> allBindings() {
        switch (this.bindingKey().kind()) {
            case CONTRIBUTION: {
                return this.allContributionBindings();
            }
            case MEMBERS_INJECTION: {
                return this.allMembersInjectionBindings().asMultimap();
            }
        }
        throw new AssertionError(this.bindingKey());
    }

    ImmutableSet<? extends Binding> bindings() {
        return ImmutableSet.copyOf((Collection)this.allBindings().values());
    }

    Binding binding() {
        return (Binding)Iterables.getOnlyElement(this.bindings());
    }

    boolean isEmpty() {
        return this.bindings().isEmpty() && this.multibindingDeclarations().isEmpty() && this.optionalBindingDeclarations().isEmpty() && this.subcomponentDeclarations().isEmpty();
    }

    ImmutableSet<? extends Binding> ownedBindings() {
        return this.allBindings().get((Object)this.owningComponent());
    }

    ImmutableSet<ContributionBinding> contributionBindings() {
        return ImmutableSet.copyOf((Collection)this.allContributionBindings().values());
    }

    ComponentDescriptor owningComponent(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)this.contributionBindings().contains((Object)binding), (String)"binding is not resolved for %s: %s", (Object)this.bindingKey(), (Object)binding);
        return (ComponentDescriptor)Iterables.getOnlyElement((Iterable)this.allContributionBindings().inverse().get((Object)binding));
    }

    Optional<MembersInjectionBinding> membersInjectionBinding() {
        ImmutableSet membersInjectionBindings = FluentIterable.from((Iterable)this.allMembersInjectionBindings().values()).toSet();
        return membersInjectionBindings.isEmpty() ? Optional.empty() : Optional.of((MembersInjectionBinding)Iterables.getOnlyElement((Iterable)membersInjectionBindings));
    }

    static ResolvedBindings forContributionBindings(BindingKey bindingKey, ComponentDescriptor owningComponent, Multimap<ComponentDescriptor, ? extends ContributionBinding> contributionBindings, Iterable<MultibindingDeclaration> multibindings, Iterable<SubcomponentDeclaration> subcomponentDeclarations, Iterable<OptionalBindingDeclaration> optionalBindingDeclarations) {
        Preconditions.checkArgument((boolean)bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION));
        return new AutoValue_ResolvedBindings(bindingKey, owningComponent, (ImmutableSetMultimap<ComponentDescriptor, ContributionBinding>)ImmutableSetMultimap.copyOf(contributionBindings), (ImmutableMap<ComponentDescriptor, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.copyOf(multibindings), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.copyOf(subcomponentDeclarations), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.copyOf(optionalBindingDeclarations));
    }

    static ResolvedBindings forMembersInjectionBinding(BindingKey bindingKey, ComponentDescriptor owningComponent, MembersInjectionBinding ownedMembersInjectionBinding) {
        Preconditions.checkArgument((boolean)bindingKey.kind().equals((Object)BindingKey.Kind.MEMBERS_INJECTION));
        return new AutoValue_ResolvedBindings(bindingKey, owningComponent, (ImmutableSetMultimap<ComponentDescriptor, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<ComponentDescriptor, MembersInjectionBinding>)ImmutableMap.of((Object)owningComponent, (Object)ownedMembersInjectionBinding), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of(), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.of(), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.of());
    }

    static ResolvedBindings noBindings(BindingKey bindingKey, ComponentDescriptor owningComponent) {
        return new AutoValue_ResolvedBindings(bindingKey, owningComponent, (ImmutableSetMultimap<ComponentDescriptor, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<ComponentDescriptor, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of(), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.of(), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.of());
    }

    ResolvedBindings asInheritedIn(ComponentDescriptor owningComponent) {
        return new AutoValue_ResolvedBindings(this.bindingKey(), owningComponent, this.allContributionBindings(), this.allMembersInjectionBindings(), this.multibindingDeclarations(), this.subcomponentDeclarations(), this.optionalBindingDeclarations());
    }

    boolean isMultibindingContribution() {
        return this.contributionBindings().size() == 1 && this.contributionBinding().contributionType().isMultibinding();
    }

    ContributionBinding contributionBinding() {
        return (ContributionBinding)Iterables.getOnlyElement(this.contributionBindings());
    }

    @Override
    public BindingType bindingType() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"empty bindings for %s", (Object)this.bindingKey());
        if (!(!this.bindings().isEmpty() || this.multibindingDeclarations().isEmpty() && this.subcomponentDeclarations().isEmpty())) {
            return BindingType.PROVISION;
        }
        ImmutableSet<BindingType> bindingTypes = this.bindingTypes();
        Preconditions.checkState((bindingTypes.size() == 1 ? 1 : 0) != 0, (String)"conflicting binding types: %s", this.bindings());
        return (BindingType)((Object)Iterables.getOnlyElement(bindingTypes));
    }

    ImmutableSet<BindingType> bindingTypes() {
        return this.bindings().stream().map(BindingType.HasBindingType::bindingType).collect(DaggerStreams.toImmutableSet());
    }

    @Override
    public ContributionType contributionType() {
        return this.contributionBinding().contributionType();
    }

    Class<?> frameworkClass() {
        return this.bindingType().frameworkClass();
    }

    Optional<Scope> scope() {
        return ((Binding)Iterables.getOnlyElement(this.bindings())).scope();
    }
}

