/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.Util;
import dagger.model.Scope;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class ReferenceReleasingManagerFields {
    private final Map<Scope, MemberSelect> referenceReleasingManagerFields = new HashMap<Scope, MemberSelect>();
    private final BindingGraph graph;
    private final GeneratedComponentModel generatedComponentModel;

    ReferenceReleasingManagerFields(BindingGraph graph, GeneratedComponentModel generatedComponentModel) {
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        Preconditions.checkArgument((boolean)graph.componentDescriptor().kind().isTopLevel());
    }

    boolean requiresReleasableReferences(Scope scope) {
        return this.graph.scopesRequiringReleasableReferenceManagers().contains((Object)scope);
    }

    CodeBlock getExpression(Scope scope, ClassName requestingClass) {
        return Util.reentrantComputeIfAbsent(this.referenceReleasingManagerFields, scope, this::createReferenceReleasingManagerField).getExpressionFor(requestingClass);
    }

    private MemberSelect createReferenceReleasingManagerField(Scope scope) {
        FieldSpec field = this.referenceReleasingProxyManagerField(scope);
        this.generatedComponentModel.addField(GeneratedComponentModel.FieldSpecKind.REFERENCE_RELEASING_MANAGER_FIELD, field);
        return MemberSelect.localField(this.generatedComponentModel.name(), field.name);
    }

    private FieldSpec referenceReleasingProxyManagerField(Scope scope) {
        String fieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, scope.scopeAnnotationElement().getSimpleName() + "References");
        return FieldSpec.builder((TypeName)TypeNames.REFERENCE_RELEASING_PROVIDER_MANAGER, (String)this.generatedComponentModel.getUniqueFieldName(fieldName), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T($T.class)", new Object[]{TypeNames.REFERENCE_RELEASING_PROVIDER_MANAGER, scope.scopeAnnotationElement()}).addJavadoc("The manager that releases references for the {@link $T} scope.\n", new Object[]{scope.scopeAnnotationElement()}).build();
    }
}

