/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import java.lang.annotation.Annotation;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ProvidesMethodValidator
extends BindingMethodValidator {
    ProvidesMethodValidator(Elements elements, Types types) {
        super(elements, types, Provides.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), BindingMethodValidator.Abstractness.MUST_BE_CONCRETE, BindingMethodValidator.ExceptionSuperclass.RUNTIME_EXCEPTION, BindingMethodValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS);
    }

    @Override
    protected void checkMethod(ValidationReport.Builder<ExecutableElement> builder) {
        super.checkMethod(builder);
        this.checkDependsOnProducers(builder);
    }

    private void checkDependsOnProducers(ValidationReport.Builder<ExecutableElement> builder) {
        for (VariableElement variableElement : builder.getSubject().getParameters()) {
            if (!FrameworkTypes.isProducerType(variableElement.asType())) continue;
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(variableElement.asType()), variableElement);
        }
    }
}

