/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.InjectValidator;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.Keys;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.ValidationReport;
import dagger.model.Key;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class InjectBindingRegistryImpl
implements InjectBindingRegistry {
    private final Elements elements;
    private final Types types;
    private final Messager messager;
    private final InjectValidator injectValidator;
    private final InjectValidator injectValidatorWhenGeneratingCode;
    private final KeyFactory keyFactory;
    private final ProvisionBinding.Factory provisionBindingFactory;
    private final MembersInjectionBinding.Factory membersInjectionBindingFactory;
    private final CompilerOptions compilerOptions;
    private final BindingsCollection<ProvisionBinding> provisionBindings = new BindingsCollection(BindingType.PROVISION);
    private final BindingsCollection<MembersInjectionBinding> membersInjectionBindings = new BindingsCollection(BindingType.MEMBERS_INJECTION);

    InjectBindingRegistryImpl(Elements elements, Types types, Messager messager, InjectValidator injectValidator, KeyFactory keyFactory, ProvisionBinding.Factory provisionBindingFactory, MembersInjectionBinding.Factory membersInjectionBindingFactory, CompilerOptions compilerOptions) {
        this.elements = elements;
        this.types = types;
        this.messager = messager;
        this.injectValidator = injectValidator;
        this.injectValidatorWhenGeneratingCode = injectValidator.whenGeneratingCode();
        this.keyFactory = keyFactory;
        this.provisionBindingFactory = provisionBindingFactory;
        this.membersInjectionBindingFactory = membersInjectionBindingFactory;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public void generateSourcesForRequiredBindings(SourceFileGenerator<ProvisionBinding> factoryGenerator, SourceFileGenerator<MembersInjectionBinding> membersInjectorGenerator) throws SourceFileGenerationException {
        this.provisionBindings.generateBindings(factoryGenerator);
        this.membersInjectionBindings.generateBindings(membersInjectorGenerator);
    }

    private void registerBinding(ProvisionBinding binding, boolean warnIfNotAlreadyGenerated) {
        this.provisionBindings.tryRegisterBinding(binding, warnIfNotAlreadyGenerated);
        if (binding.unresolved().isPresent()) {
            this.provisionBindings.tryToGenerateBinding(binding.unresolved().get(), warnIfNotAlreadyGenerated);
        }
    }

    private void registerBinding(MembersInjectionBinding binding, boolean warnIfNotAlreadyGenerated) {
        warnIfNotAlreadyGenerated = warnIfNotAlreadyGenerated && (!InjectionAnnotations.injectedConstructors(binding.membersInjectedType()).isEmpty() ? !binding.injectionSites().isEmpty() : binding.hasLocalInjectionSites());
        this.membersInjectionBindings.tryRegisterBinding(binding, warnIfNotAlreadyGenerated);
        if (binding.unresolved().isPresent()) {
            this.membersInjectionBindings.tryToGenerateBinding(binding.unresolved().get(), warnIfNotAlreadyGenerated);
        }
    }

    @Override
    public Optional<ProvisionBinding> tryRegisterConstructor(ExecutableElement constructorElement) {
        return this.tryRegisterConstructor(constructorElement, Optional.empty(), false);
    }

    @CanIgnoreReturnValue
    private Optional<ProvisionBinding> tryRegisterConstructor(ExecutableElement constructorElement, Optional<TypeMirror> resolvedType, boolean warnIfNotAlreadyGenerated) {
        TypeElement typeElement = MoreElements.asType(constructorElement.getEnclosingElement());
        DeclaredType type = MoreTypes.asDeclared(typeElement.asType());
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(type);
        ProvisionBinding cachedBinding = this.provisionBindings.getBinding(key);
        if (cachedBinding != null) {
            return Optional.of(cachedBinding);
        }
        ValidationReport<TypeElement> report = this.injectValidator.validateConstructor(constructorElement);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            ProvisionBinding binding = this.provisionBindingFactory.forInjectConstructor(constructorElement, resolvedType);
            this.registerBinding(binding, warnIfNotAlreadyGenerated);
            if (this.membersInjectionBindingFactory.hasInjectedMembersIn(type)) {
                this.tryRegisterMembersInjectedType(typeElement, resolvedType, warnIfNotAlreadyGenerated);
            }
            return Optional.of(binding);
        }
        return Optional.empty();
    }

    @Override
    public Optional<MembersInjectionBinding> tryRegisterMembersInjectedType(TypeElement typeElement) {
        return this.tryRegisterMembersInjectedType(typeElement, Optional.empty(), false);
    }

    @CanIgnoreReturnValue
    private Optional<MembersInjectionBinding> tryRegisterMembersInjectedType(TypeElement typeElement, Optional<TypeMirror> resolvedType, boolean warnIfNotAlreadyGenerated) {
        DeclaredType type = MoreTypes.asDeclared(typeElement.asType());
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(type);
        MembersInjectionBinding cachedBinding = this.membersInjectionBindings.getBinding(key);
        if (cachedBinding != null) {
            return Optional.of(cachedBinding);
        }
        ValidationReport<TypeElement> report = this.injectValidator.validateMembersInjectionType(typeElement);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            MembersInjectionBinding binding = this.membersInjectionBindingFactory.forInjectedType(type, resolvedType);
            this.registerBinding(binding, warnIfNotAlreadyGenerated);
            if (binding.parentKey().isPresent() && !binding.injectionSites().isEmpty()) {
                this.getOrFindMembersInjectionBinding(binding.parentKey().get());
            }
            return Optional.of(binding);
        }
        return Optional.empty();
    }

    @Override
    @CanIgnoreReturnValue
    public Optional<ProvisionBinding> getOrFindProvisionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        if (!Keys.isValidImplicitProvisionKey(key, this.types)) {
            return Optional.empty();
        }
        ProvisionBinding binding = this.provisionBindings.getBinding(key);
        if (binding != null) {
            return Optional.of(binding);
        }
        TypeElement element = MoreElements.asType(this.types.asElement(key.type()));
        ImmutableSet<ExecutableElement> injectConstructors = InjectionAnnotations.injectedConstructors(element);
        switch (injectConstructors.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return this.tryRegisterConstructor((ExecutableElement)Iterables.getOnlyElement(injectConstructors), Optional.of(key.type()), true);
            }
        }
        throw new IllegalStateException("Found multiple @Inject constructors: " + injectConstructors);
    }

    @Override
    @CanIgnoreReturnValue
    public Optional<MembersInjectionBinding> getOrFindMembersInjectionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)Keys.isValidMembersInjectionKey(key));
        MembersInjectionBinding binding = this.membersInjectionBindings.getBinding(key);
        if (binding != null) {
            return Optional.of(binding);
        }
        Optional<MembersInjectionBinding> newBinding = this.tryRegisterMembersInjectedType(MoreTypes.asTypeElement(key.type()), Optional.of(key.type()), true);
        return newBinding;
    }

    final class BindingsCollection<B extends Binding> {
        private final BindingType bindingType;
        private final Map<Key, B> bindingsByKey = Maps.newLinkedHashMap();
        private final Deque<B> bindingsRequiringGeneration = new ArrayDeque<B>();
        private final Set<Key> materializedBindingKeys = Sets.newLinkedHashSet();

        BindingsCollection(BindingType bindingType) {
            this.bindingType = bindingType;
        }

        void generateBindings(SourceFileGenerator<B> generator) throws SourceFileGenerationException {
            Binding binding = (Binding)this.bindingsRequiringGeneration.poll();
            while (binding != null) {
                Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0);
                if (InjectBindingRegistryImpl.this.injectValidatorWhenGeneratingCode.isValidType(binding.key().type())) {
                    generator.generate(binding);
                }
                this.materializedBindingKeys.add(binding.key());
                binding = (Binding)this.bindingsRequiringGeneration.poll();
            }
            this.bindingsByKey.clear();
        }

        B getBinding(Key key) {
            return (B)((Binding)this.bindingsByKey.get(key));
        }

        void tryRegisterBinding(B binding, boolean warnIfNotAlreadyGenerated) {
            this.tryToCacheBinding(binding);
            this.tryToGenerateBinding(binding, warnIfNotAlreadyGenerated);
        }

        void tryToGenerateBinding(B binding, boolean warnIfNotAlreadyGenerated) {
            if (this.shouldGenerateBinding(binding, SourceFiles.generatedClassNameForBinding(binding))) {
                this.bindingsRequiringGeneration.offer(binding);
                if (InjectBindingRegistryImpl.this.compilerOptions.warnIfInjectionFactoryNotGeneratedUpstream() && warnIfNotAlreadyGenerated) {
                    InjectBindingRegistryImpl.this.messager.printMessage(Diagnostic.Kind.NOTE, String.format("Generating a %s for %s. Prefer to run the dagger processor over that class instead.", this.bindingType.frameworkClass().getSimpleName(), InjectBindingRegistryImpl.this.types.erasure(((Binding)binding).key().type())));
                }
            }
        }

        private boolean shouldGenerateBinding(B binding, ClassName factoryName) {
            return !((Binding)binding).unresolved().isPresent() && InjectBindingRegistryImpl.this.elements.getTypeElement(factoryName.toString()) == null && !this.materializedBindingKeys.contains(((Binding)binding).key()) && !this.bindingsRequiringGeneration.contains(binding);
        }

        private void tryToCacheBinding(B binding) {
            if (((Binding)binding).unresolved().isPresent() || ((BindingDeclaration)binding).bindingTypeElement().get().getTypeParameters().isEmpty()) {
                Key key = ((Binding)binding).key();
                Binding previousValue = (Binding)this.bindingsByKey.put(key, binding);
                Preconditions.checkState((previousValue == null || binding.equals(previousValue) ? 1 : 0) != 0, (String)"couldn't register %s. %s was already registered for %s", binding, (Object)previousValue, (Object)key);
            }
        }
    }
}

