/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkFieldSupplier;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.RequestKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class FrameworkInstanceBindingExpression
extends BindingExpression {
    private final ComponentBindingExpressions componentBindingExpressions;
    private final FrameworkFieldSupplier frameworkFieldSupplier;
    private final FrameworkType frameworkType;
    private final DaggerTypes types;
    private final Elements elements;

    FrameworkInstanceBindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind, ComponentBindingExpressions componentBindingExpressions, FrameworkType frameworkType, FrameworkFieldSupplier frameworkFieldSupplier, DaggerTypes types, Elements elements) {
        super(resolvedBindings, requestKind);
        this.componentBindingExpressions = componentBindingExpressions;
        this.frameworkType = frameworkType;
        this.frameworkFieldSupplier = frameworkFieldSupplier;
        this.types = types;
        this.elements = elements;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        if (this.requestKind().equals((Object)this.frameworkRequestKind())) {
            MemberSelect memberSelect = this.frameworkFieldSupplier.memberSelect();
            TypeMirror expressionType = Accessibility.isTypeAccessibleFrom(this.instanceType(), requestingClass.packageName()) || FrameworkInstanceBindingExpression.isInlinedFactoryCreation(memberSelect) || this.frameworkFieldSupplier.fieldTypeReplaced() ? this.types.wrapType(this.instanceType(), this.resolvedBindings().frameworkClass()) : this.rawFrameworkType();
            return Expression.create(expressionType, memberSelect.getExpressionFor(requestingClass));
        }
        return this.frameworkType.to(this.requestKind(), this.componentBindingExpressions.getDependencyExpression(this.bindingKey(), this.frameworkRequestKind(), requestingClass), this.types);
    }

    private RequestKind frameworkRequestKind() {
        switch (this.frameworkType) {
            case PROVIDER: {
                return RequestKind.PROVIDER;
            }
            case PRODUCER: {
                return RequestKind.PRODUCER;
            }
            case MEMBERS_INJECTOR: {
                return RequestKind.MEMBERS_INJECTOR;
            }
        }
        throw new AssertionError();
    }

    private TypeMirror instanceType() {
        return this.resolvedBindings().membersInjectionBinding().map(binding -> binding.key().type()).orElseGet(() -> this.resolvedBindings().contributionBinding().contributedType());
    }

    private static boolean isInlinedFactoryCreation(MemberSelect memberSelect) {
        return memberSelect.staticMember();
    }

    private DeclaredType rawFrameworkType() {
        return this.types.getDeclaredType(this.elements.getTypeElement(this.resolvedBindings().frameworkClass().getCanonicalName()), new TypeMirror[0]);
    }
}

