/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.ValidationReport;
import dagger.model.Scope;
import dagger.releasablereferences.ForReleasableReferences;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ForReleasableReferencesValidator
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;

    ForReleasableReferencesValidator(Messager messager) {
        this.messager = messager;
    }

    ValidationReport<Element> validateAnnotatedElement(Element annotatedElement) {
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(annotatedElement, ForReleasableReferences.class));
        ValidationReport.Builder<Element> report = ValidationReport.about(annotatedElement);
        AnnotationMirror annotation = DaggerElements.getAnnotationMirror(annotatedElement, ForReleasableReferences.class).get();
        TypeElement scopeType = MoreTypes.asTypeElement(MoreAnnotationMirrors.getTypeValue(annotation, "value"));
        if (!Scope.isScope((TypeElement)scopeType)) {
            report.addError(ErrorMessages.forReleasableReferencesValueNotAScope(scopeType), annotatedElement, annotation);
        } else if (!Scopes.scope(scopeType).canReleaseReferences()) {
            report.addError(ErrorMessages.forReleasableReferencesValueCannotReleaseReferences(scopeType), annotatedElement, annotation);
        }
        return report.build();
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(ForReleasableReferences.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        elementsByAnnotation.get(ForReleasableReferences.class).stream().map(this::validateAnnotatedElement).forEach(report -> report.printMessagesTo(this.messager));
        return ImmutableSet.of();
    }
}

