/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.GwtCompatibility;
import dagger.internal.codegen.InjectionMethods;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class FactoryGenerator
extends SourceFileGenerator<ProvisionBinding> {
    private final Types types;
    private final CompilerOptions compilerOptions;

    FactoryGenerator(Filer filer, Elements elements, Types types, CompilerOptions compilerOptions) {
        super(filer, elements);
        this.types = types;
        this.compilerOptions = compilerOptions;
    }

    @Override
    ClassName nameGeneratedType(ProvisionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding);
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(ProvisionBinding binding) {
        return binding.bindingElement();
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, ProvisionBinding binding) {
        com.google.common.base.Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        com.google.common.base.Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        return binding.factoryCreationStrategy().equals((Object)ContributionBinding.FactoryCreationStrategy.DELEGATE) ? Optional.empty() : Optional.of(this.factoryBuilder(binding));
    }

    private TypeSpec.Builder factoryBuilder(ProvisionBinding binding) {
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder((ClassName)this.nameGeneratedType(binding)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(FactoryGenerator.factoryTypeName(binding)).addTypeVariables(FactoryGenerator.typeParameters(binding));
        this.addConstructorAndFields(binding, factoryBuilder);
        factoryBuilder.addMethod(this.getMethod(binding));
        this.addCreateMethod(binding, factoryBuilder);
        InjectionMethods.ProvisionMethod.create(binding, this.compilerOptions).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addMethod(arg_0));
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addAnnotation(arg_0));
        MapKeys.mapKeyFactoryMethod(binding, this.types).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addMethod(arg_0));
        return factoryBuilder;
    }

    private void addConstructorAndFields(ProvisionBinding binding, TypeSpec.Builder factoryBuilder) {
        if (binding.factoryCreationStrategy().equals((Object)ContributionBinding.FactoryCreationStrategy.SINGLETON_INSTANCE)) {
            return;
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.constructorParams(binding).forEach(param -> {
            constructor.addParameter(param).addStatement("this.$1N = $1N", new Object[]{param});
            factoryBuilder.addField(FieldSpec.builder((TypeName)param.type, (String)param.name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        });
        factoryBuilder.addMethod(constructor.build());
    }

    private ImmutableList<ParameterSpec> constructorParams(ProvisionBinding binding) {
        ImmutableList.Builder params = ImmutableList.builder();
        this.moduleParameter(binding).ifPresent(arg_0 -> ((ImmutableList.Builder)params).add(arg_0));
        this.frameworkFields(binding).values().forEach(field -> params.add((Object)FactoryGenerator.toParameter(field)));
        return params.build();
    }

    private Optional<ParameterSpec> moduleParameter(ProvisionBinding binding) {
        if (binding.requiresModuleInstance()) {
            TypeName type = TypeName.get((TypeMirror)binding.bindingTypeElement().get().asType());
            return Optional.of(ParameterSpec.builder((TypeName)type, (String)"module", (Modifier[])new Modifier[0]).build());
        }
        return Optional.empty();
    }

    private ImmutableMap<BindingKey, FieldSpec> frameworkFields(ProvisionBinding binding) {
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        if (binding.requiresModuleInstance()) {
            uniqueFieldNames.claim("module");
        }
        ImmutableMap.Builder fields = ImmutableMap.builder();
        SourceFiles.generateBindingFieldsForDependencies(binding).forEach((bindingKey, frameworkField) -> {
            ParameterizedTypeName type = frameworkField.type();
            String name = uniqueFieldNames.getUniqueName(frameworkField.name());
            fields.put(bindingKey, (Object)FieldSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        });
        return fields.build();
    }

    private void addCreateMethod(ProvisionBinding binding, TypeSpec.Builder factoryBuilder) {
        MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)).addTypeVariables(FactoryGenerator.typeParameters(binding));
        switch (binding.factoryCreationStrategy()) {
            case SINGLETON_INSTANCE: {
                FieldSpec.Builder instanceFieldBuilder = FieldSpec.builder((TypeName)this.nameGeneratedType(binding), (String)"INSTANCE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{this.nameGeneratedType(binding)});
                if (!FactoryGenerator.typeParameters(binding).isEmpty()) {
                    instanceFieldBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
                    createMethodBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]));
                }
                createMethodBuilder.addStatement("return INSTANCE", new Object[0]);
                factoryBuilder.addField(instanceFieldBuilder.build());
                break;
            }
            case CLASS_CONSTRUCTOR: {
                ImmutableList<ParameterSpec> params = this.constructorParams(binding);
                createMethodBuilder.addParameters(params);
                createMethodBuilder.addStatement("return new $T($L)", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(Lists.transform(params, input -> CodeBlock.of((String)"$N", (Object[])new Object[]{input})))});
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        factoryBuilder.addMethod(createMethodBuilder.build());
    }

    private MethodSpec getMethod(ProvisionBinding binding) {
        TypeName providedTypeName = FactoryGenerator.providedTypeName(binding);
        MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder((String)"get").returns(providedTypeName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ImmutableMap<BindingKey, FieldSpec> frameworkFields = this.frameworkFields(binding);
        CodeBlock parametersCodeBlock = CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)SourceFiles.frameworkFieldUsages(binding.provisionDependencies(), frameworkFields).values());
        if (binding.bindingKind().equals((Object)ContributionBinding.Kind.PROVISION)) {
            binding.nullableType().ifPresent(nullableType -> CodeBlocks.addAnnotation(getMethodBuilder, nullableType));
            CodeBlock methodCall = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{binding.requiresModuleInstance() ? "module" : CodeBlock.of((String)"$T", (Object[])new Object[]{ClassName.get((TypeElement)binding.bindingTypeElement().get())}), binding.bindingElement().get().getSimpleName(), parametersCodeBlock});
            getMethodBuilder.addStatement("return $L", new Object[]{binding.shouldCheckForNull(this.compilerOptions) ? FactoryGenerator.checkNotNullProvidesMethod(methodCall) : methodCall});
        } else if (!binding.injectionSites().isEmpty()) {
            CodeBlock instance = CodeBlock.of((String)"instance", (Object[])new Object[0]);
            getMethodBuilder.addStatement("$1T $2L = new $1T($3L)", new Object[]{providedTypeName, instance, parametersCodeBlock}).addCode(InjectionMethods.InjectionSiteMethod.invokeAll(binding.injectionSites(), this.nameGeneratedType(binding), instance, binding.key().type(), this.types, arg_0 -> SourceFiles.frameworkFieldUsages(binding.dependencies(), frameworkFields).get(arg_0))).addStatement("return $L", new Object[]{instance});
        } else {
            getMethodBuilder.addStatement("return new $T($L)", new Object[]{providedTypeName, parametersCodeBlock});
        }
        return getMethodBuilder.build();
    }

    private static TypeName providedTypeName(ProvisionBinding binding) {
        return TypeName.get((TypeMirror)binding.contributedType());
    }

    private static TypeName factoryTypeName(ProvisionBinding binding) {
        return TypeNames.factoryOf(FactoryGenerator.providedTypeName(binding));
    }

    private static ParameterSpec toParameter(FieldSpec field) {
        return ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).build();
    }

    private static ImmutableList<TypeVariableName> typeParameters(ProvisionBinding binding) {
        if (binding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) || binding.requiresModuleInstance()) {
            return SourceFiles.bindingTypeElementTypeVariableNames(binding);
        }
        return ImmutableList.of();
    }

    static CodeBlock checkNotNullProvidesMethod(CodeBlock providesMethodInvocation) {
        return CodeBlock.of((String)"$T.checkNotNull($L, $S)", (Object[])new Object[]{Preconditions.class, providesMethodInvocation, "Cannot return null from a non-@Nullable @Provides method"});
    }
}

