/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.ComponentTreeTraverser;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.RequestKinds;
import dagger.model.Key;
import dagger.shaded.auto.common.MoreElements;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor7;

final class DependencyRequestFormatter
extends Formatter<DependencyRequest> {
    private final DaggerTypes types;

    DependencyRequestFormatter(DaggerTypes types) {
        this.types = types;
    }

    @Override
    String format(ComponentTreeTraverser.DependencyTrace dependencyTrace) {
        AtomicReference<ImmutableSet> dependentOptionalBindingDeclarations = new AtomicReference<ImmutableSet>(ImmutableSet.of());
        return Joiner.on((char)'\n').join((Iterable)dependencyTrace.transform((dependencyRequest, resolvedBindings) -> {
            ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations = dependentOptionalBindingDeclarations.getAndSet(resolvedBindings.optionalBindingDeclarations());
            return optionalBindingDeclarations.isEmpty() ? this.format((DependencyRequest)dependencyRequest) : this.formatSyntheticOptionalBindingDependency(optionalBindingDeclarations);
        }).filter(f -> !f.isEmpty()).collect(DaggerStreams.toImmutableList()).reverse());
    }

    @Override
    public String format(DependencyRequest request) {
        if (!request.requestElement().isPresent()) {
            return "";
        }
        return request.requestElement().get().accept(new ElementKindVisitor7<String, DependencyRequest>(){

            @Override
            public String visitExecutableAsMethod(ExecutableElement method, DependencyRequest request) {
                StringBuilder builder = new StringBuilder();
                builder.append("    ").append(DependencyRequestFormatter.this.formatKey(request.key())).append(" is ").append(DependencyRequestFormatter.this.componentMethodRequestVerb(request)).append(" at\n").append("        ");
                DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(method, builder);
                builder.append('(');
                for (VariableElement variableElement : method.getParameters()) {
                    builder.append(variableElement.getSimpleName());
                }
                builder.append(')');
                return builder.toString();
            }

            @Override
            public String visitVariableAsParameter(VariableElement variable, DependencyRequest request) {
                StringBuilder builder = new StringBuilder();
                DependencyRequestFormatter.this.appendRequestedTypeIsInjectedAt(builder, request);
                ExecutableElement methodOrConstructor = MoreElements.asExecutable(variable.getEnclosingElement());
                DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(methodOrConstructor, builder).append('(');
                List<? extends VariableElement> parameters = methodOrConstructor.getParameters();
                int parameterIndex = parameters.indexOf(variable);
                builder.append(DependencyRequestFormatter.this.formatArgumentInList(parameterIndex, parameters.size(), variable.getSimpleName()));
                builder.append(')');
                return builder.toString();
            }

            @Override
            public String visitVariableAsField(VariableElement variable, DependencyRequest request) {
                StringBuilder builder = new StringBuilder();
                DependencyRequestFormatter.this.appendRequestedTypeIsInjectedAt(builder, request);
                DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(variable, builder);
                return builder.toString();
            }

            @Override
            public String visitType(TypeElement e, DependencyRequest request) {
                return "";
            }

            @Override
            protected String defaultAction(Element element, DependencyRequest request) {
                throw new IllegalStateException("Invalid request " + (Object)((Object)element.getKind()) + " element " + element);
            }
        }, request);
    }

    @CanIgnoreReturnValue
    private StringBuilder appendRequestedTypeIsInjectedAt(StringBuilder builder, DependencyRequest request) {
        TypeMirror requestedType = RequestKinds.requestType(request.kind(), request.key().type(), this.types);
        return builder.append("    ").append(this.formatKey(request.key().qualifier(), requestedType)).append(" is injected at\n").append("        ");
    }

    private String formatKey(Key key) {
        return this.formatKey(key.qualifier(), key.type());
    }

    private String formatKey(Optional<AnnotationMirror> qualifier, TypeMirror type) {
        StringBuilder builder = new StringBuilder();
        if (qualifier.isPresent()) {
            builder.append(qualifier.get()).append(' ');
        }
        builder.append(type);
        return builder.toString();
    }

    private String componentMethodRequestVerb(DependencyRequest request) {
        switch (request.kind()) {
            case FUTURE: 
            case PRODUCER: {
                return "produced";
            }
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: 
            case PROVIDER_OF_LAZY: {
                return "provided";
            }
            case MEMBERS_INJECTOR: {
                return "injected";
            }
        }
        throw new AssertionError((Object)("illegal request kind for method: " + request));
    }

    @CanIgnoreReturnValue
    private StringBuilder appendEnclosingTypeAndMemberName(Element member, StringBuilder builder) {
        TypeElement type = MoreElements.asType(member.getEnclosingElement());
        return builder.append(type.getQualifiedName()).append('.').append(member.getSimpleName());
    }

    private String formatSyntheticOptionalBindingDependency(ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations) {
        OptionalBindingDeclaration optionalBindingDeclaration = (OptionalBindingDeclaration)optionalBindingDeclarations.iterator().next();
        StringBuilder builder = new StringBuilder();
        builder.append("    ").append("@BindsOptionalOf ").append(this.formatKey(optionalBindingDeclaration.key())).append(" is declared at\n").append("        ");
        this.appendEnclosingTypeAndMemberName(optionalBindingDeclaration.bindingElement().get(), builder);
        builder.append("()");
        if (optionalBindingDeclarations.size() > 1) {
            builder.append(", among others");
        }
        return builder.toString();
    }
}

