/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.MembersInjector;
import dagger.internal.codegen.AutoValue_DependencyRequest;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.Optionals;
import dagger.internal.codegen.RequestKinds;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor7;

abstract class DependencyRequest {
    DependencyRequest() {
    }

    abstract RequestKind kind();

    abstract Key key();

    BindingKey bindingKey() {
        switch (this.kind()) {
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: 
            case PROVIDER_OF_LAZY: 
            case PRODUCER: 
            case PRODUCED: 
            case FUTURE: {
                return BindingKey.contribution(this.key());
            }
            case MEMBERS_INJECTOR: {
                return BindingKey.membersInjection(this.key());
            }
        }
        throw new AssertionError(this);
    }

    abstract Optional<Element> requestElement();

    boolean requestsPrimitiveType() {
        return this.requestElement().map(element -> element.asType().getKind().isPrimitive()).orElse(false);
    }

    abstract boolean isNullable();

    abstract Optional<String> overriddenVariableName();

    private static Builder builder() {
        return new AutoValue_DependencyRequest.Builder().isNullable(false);
    }

    static KindAndType extractKindAndType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor7<KindAndType, Void>(){

            @Override
            public KindAndType visitError(ErrorType errorType, Void p) {
                throw new TypeNotPresentException(errorType.toString(), null);
            }

            @Override
            public KindAndType visitExecutable(ExecutableType executableType, Void p) {
                return executableType.getReturnType().accept(this, null);
            }

            @Override
            public KindAndType visitDeclared(DeclaredType declaredType, Void p) {
                return KindAndType.from(declaredType).orElse(this.defaultAction((TypeMirror)declaredType, p));
            }

            @Override
            protected KindAndType defaultAction(TypeMirror otherType, Void p) {
                return new KindAndType(RequestKind.INSTANCE, otherType);
            }
        }, null);
    }

    static final class Factory {
        private final KeyFactory keyFactory;
        private static final ImmutableSet<RequestKind> WRAPPING_MAP_VALUE_FRAMEWORK_TYPES = ImmutableSet.of((Object)RequestKind.PROVIDER, (Object)RequestKind.PRODUCER);

        Factory(KeyFactory keyFactory) {
            this.keyFactory = keyFactory;
        }

        ImmutableSet<DependencyRequest> forRequiredResolvedVariables(List<? extends VariableElement> variables, List<? extends TypeMirror> resolvedTypes) {
            Preconditions.checkState((resolvedTypes.size() == variables.size() ? 1 : 0) != 0);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < variables.size(); ++i) {
                builder.add((Object)this.forRequiredResolvedVariable(variables.get(i), resolvedTypes.get(i)));
            }
            return builder.build();
        }

        DependencyRequest providerForImplicitMapBinding(Key mapOfFactoryKey) {
            return DependencyRequest.builder().kind(RequestKind.PROVIDER).key(mapOfFactoryKey).build();
        }

        ImmutableSet<DependencyRequest> forMultibindingContributions(Key multibindingKey, Iterable<ContributionBinding> multibindingContributions) {
            ImmutableSet.Builder requests = ImmutableSet.builder();
            for (ContributionBinding multibindingContribution : multibindingContributions) {
                requests.add((Object)this.forMultibindingContribution(multibindingKey, multibindingContribution));
            }
            return requests.build();
        }

        private DependencyRequest forMultibindingContribution(Key multibindingKey, ContributionBinding multibindingContribution) {
            Preconditions.checkArgument((boolean)multibindingContribution.key().multibindingContributionIdentifier().isPresent(), (String)"multibindingContribution's key must have a multibinding contribution identifier: %s", (Object)multibindingContribution);
            return DependencyRequest.builder().kind(this.multibindingContributionRequestKind(multibindingKey, multibindingContribution)).key(multibindingContribution.key()).build();
        }

        private RequestKind multibindingContributionRequestKind(Key multibindingKey, ContributionBinding multibindingContribution) {
            switch (multibindingContribution.contributionType()) {
                case MAP: {
                    MapType mapType = MapType.from(multibindingKey);
                    for (RequestKind kind : WRAPPING_MAP_VALUE_FRAMEWORK_TYPES) {
                        if (!mapType.valuesAreTypeOf(RequestKinds.frameworkClass(kind).get())) continue;
                        return kind;
                    }
                }
                case SET: 
                case SET_VALUES: {
                    return RequestKind.INSTANCE;
                }
                case UNIQUE: {
                    throw new IllegalArgumentException("multibindingContribution must be a multibinding: " + multibindingContribution);
                }
            }
            throw new AssertionError((Object)multibindingContribution.toString());
        }

        DependencyRequest forRequiredVariable(VariableElement variableElement) {
            return this.forRequiredVariable(variableElement, Optional.empty());
        }

        DependencyRequest forRequiredVariable(VariableElement variableElement, Optional<String> name) {
            Preconditions.checkNotNull((Object)variableElement);
            TypeMirror type = variableElement.asType();
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(variableElement);
            return this.newDependencyRequest(variableElement, type, qualifier, name);
        }

        DependencyRequest forRequiredResolvedVariable(VariableElement variableElement, TypeMirror resolvedType) {
            Preconditions.checkNotNull((Object)variableElement);
            Preconditions.checkNotNull((Object)resolvedType);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(variableElement);
            return this.newDependencyRequest(variableElement, resolvedType, qualifier, Optional.empty());
        }

        DependencyRequest forComponentProvisionMethod(ExecutableElement provisionMethod, ExecutableType provisionMethodType) {
            Preconditions.checkNotNull((Object)provisionMethod);
            Preconditions.checkNotNull((Object)provisionMethodType);
            Preconditions.checkArgument((boolean)provisionMethod.getParameters().isEmpty(), (String)"Component provision methods must be empty: %s", (Object)provisionMethod);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(provisionMethod);
            return this.newDependencyRequest(provisionMethod, provisionMethodType.getReturnType(), qualifier, Optional.empty());
        }

        DependencyRequest forComponentProductionMethod(ExecutableElement productionMethod, ExecutableType productionMethodType) {
            Preconditions.checkNotNull((Object)productionMethod);
            Preconditions.checkNotNull((Object)productionMethodType);
            Preconditions.checkArgument((boolean)productionMethod.getParameters().isEmpty(), (String)"Component production methods must be empty: %s", (Object)productionMethod);
            TypeMirror type = productionMethodType.getReturnType();
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(productionMethod);
            if (MoreTypes.isTypeOf(ListenableFuture.class, type)) {
                return DependencyRequest.builder().kind(RequestKind.FUTURE).key(this.keyFactory.forQualifiedType(qualifier, (TypeMirror)Iterables.getOnlyElement(((DeclaredType)type).getTypeArguments()))).requestElement(productionMethod).build();
            }
            return this.newDependencyRequest(productionMethod, type, qualifier, Optional.empty());
        }

        DependencyRequest forComponentMembersInjectionMethod(ExecutableElement membersInjectionMethod, ExecutableType membersInjectionMethodType) {
            Preconditions.checkNotNull((Object)membersInjectionMethod);
            Preconditions.checkNotNull((Object)membersInjectionMethodType);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(membersInjectionMethod);
            Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
            TypeMirror returnType = membersInjectionMethodType.getReturnType();
            TypeMirror membersInjectedType = MoreTypes.isType(returnType) && MoreTypes.isTypeOf(MembersInjector.class, returnType) ? (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments()) : (TypeMirror)Iterables.getOnlyElement(membersInjectionMethodType.getParameterTypes());
            return DependencyRequest.builder().kind(RequestKind.MEMBERS_INJECTOR).key(this.keyFactory.forMembersInjectedType(membersInjectedType)).requestElement(membersInjectionMethod).build();
        }

        DependencyRequest forProductionImplementationExecutor() {
            Key key = this.keyFactory.forProductionImplementationExecutor();
            return DependencyRequest.builder().kind(RequestKind.PROVIDER).key(key).requestElement(MoreTypes.asElement(key.type())).build();
        }

        DependencyRequest forProductionComponentMonitor() {
            Key key = this.keyFactory.forProductionComponentMonitor();
            return DependencyRequest.builder().kind(RequestKind.PROVIDER).key(key).requestElement(MoreTypes.asElement(key.type())).overriddenVariableName(Optional.of("monitor")).build();
        }

        DependencyRequest forSyntheticPresentOptionalBinding(Key requestKey, RequestKind kind) {
            Optional<Key> key = this.keyFactory.unwrapOptional(requestKey);
            Preconditions.checkArgument((boolean)key.isPresent(), (String)"not a request for optional: %s", (Object)requestKey);
            return DependencyRequest.builder().kind(kind).key(key.get()).isNullable(this.allowsNull(DependencyRequest.extractKindAndType(OptionalType.from(requestKey).valueType()).kind(), Optional.empty())).build();
        }

        private DependencyRequest newDependencyRequest(Element requestElement, TypeMirror type, Optional<AnnotationMirror> qualifier, Optional<String> name) {
            KindAndType kindAndType = DependencyRequest.extractKindAndType(type);
            if (kindAndType.kind().equals((Object)RequestKind.MEMBERS_INJECTOR)) {
                Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
            }
            return DependencyRequest.builder().kind(kindAndType.kind()).key(this.keyFactory.forQualifiedType(qualifier, kindAndType.type())).requestElement(requestElement).isNullable(this.allowsNull(kindAndType.kind(), ConfigurationAnnotations.getNullableType(requestElement))).overriddenVariableName(name).build();
        }

        private boolean allowsNull(RequestKind kind, Optional<DeclaredType> nullableType) {
            return kind.equals((Object)RequestKind.INSTANCE) ? nullableType.isPresent() : true;
        }
    }

    @CanIgnoreReturnValue
    static abstract class Builder {
        Builder() {
        }

        abstract Builder kind(RequestKind var1);

        abstract Builder key(Key var1);

        abstract Builder requestElement(Element var1);

        abstract Builder isNullable(boolean var1);

        abstract Builder overriddenVariableName(Optional<String> var1);

        @CheckReturnValue
        abstract DependencyRequest build();
    }

    static final class KindAndType {
        private final RequestKind kind;
        private final TypeMirror type;

        KindAndType(RequestKind kind, TypeMirror type) {
            this.kind = (RequestKind)Preconditions.checkNotNull((Object)kind);
            this.type = (TypeMirror)Preconditions.checkNotNull((Object)type);
        }

        RequestKind kind() {
            return this.kind;
        }

        TypeMirror type() {
            return this.type;
        }

        static Optional<KindAndType> from(TypeMirror type) {
            for (RequestKind kind : RequestKind.values()) {
                Optional<KindAndType> kindAndType = KindAndType.from(kind, type);
                if (!kindAndType.isPresent()) continue;
                return Optionals.firstPresent(kindAndType.get().maybeProviderOfLazy(), kindAndType, new Optional[0]);
            }
            return Optional.empty();
        }

        private static Optional<KindAndType> from(RequestKind kind, TypeMirror type) {
            Optional<Class<?>> frameworkClass = RequestKinds.frameworkClass(kind);
            if (frameworkClass.isPresent() && MoreTypes.isType(type) && MoreTypes.isTypeOf(frameworkClass.get(), type)) {
                List<? extends TypeMirror> typeArguments = MoreTypes.asDeclared(type).getTypeArguments();
                if (typeArguments.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(new KindAndType(kind, (TypeMirror)Iterables.getOnlyElement(typeArguments)));
            }
            return Optional.empty();
        }

        private Optional<KindAndType> maybeProviderOfLazy() {
            Optional<KindAndType> providedKindAndType;
            if (this.kind().equals((Object)RequestKind.PROVIDER) && (providedKindAndType = KindAndType.from(this.type())).isPresent() && providedKindAndType.get().kind().equals((Object)RequestKind.LAZY)) {
                return Optional.of(new KindAndType(RequestKind.PROVIDER_OF_LAZY, providedKindAndType.get().type()));
            }
            return Optional.empty();
        }
    }
}

