/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.AnnotationMirrors;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;

final class CanReleaseReferencesValidator {
    CanReleaseReferencesValidator() {
    }

    ValidationReport<TypeElement> validate(TypeElement annotatedElement) {
        ValidationReport.Builder<TypeElement> report = ValidationReport.about(annotatedElement);
        this.checkNoSourceRetention(annotatedElement, report);
        return report.build();
    }

    private void checkNoSourceRetention(TypeElement annotatedElement, ValidationReport.Builder<TypeElement> report) {
        DaggerElements.getAnnotationMirror(annotatedElement, Retention.class).ifPresent(retention -> {
            if (this.getRetentionPolicy((AnnotationMirror)retention).equals((Object)RetentionPolicy.SOURCE)) {
                report.addError("@CanReleaseReferences annotations must not have SOURCE retention", (Element)report.getSubject(), (AnnotationMirror)retention);
            }
        });
    }

    private RetentionPolicy getRetentionPolicy(AnnotationMirror retention) {
        return AnnotationMirrors.getAnnotationValue(retention, "value").accept(new SimpleAnnotationValueVisitor7<RetentionPolicy, Void>(){

            @Override
            public RetentionPolicy visitEnumConstant(VariableElement element, Void p) {
                return RetentionPolicy.valueOf(element.getSimpleName().toString());
            }
        }, null);
    }
}

