/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.ContributionType;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class BindsTypeChecker {
    private final Types types;
    private final Elements elements;

    BindsTypeChecker(Types types, Elements elements) {
        this.types = types;
        this.elements = elements;
    }

    boolean isAssignable(TypeMirror rightHandSide, TypeMirror leftHandSide, ContributionType contributionType) {
        return this.types.isAssignable(rightHandSide, this.desiredAssignableType(leftHandSide, contributionType));
    }

    private TypeMirror desiredAssignableType(TypeMirror leftHandSide, ContributionType contributionType) {
        switch (contributionType) {
            case UNIQUE: {
                return leftHandSide;
            }
            case SET: {
                DeclaredType parameterizedSetType = this.types.getDeclaredType(this.setElement(), leftHandSide);
                return this.methodParameterType(parameterizedSetType, "add");
            }
            case SET_VALUES: {
                return this.methodParameterType(MoreTypes.asDeclared(leftHandSide), "addAll");
            }
            case MAP: {
                DeclaredType parameterizedMapType = this.types.getDeclaredType(this.mapElement(), this.unboundedWildcard(), leftHandSide);
                return (TypeMirror)this.methodParameterTypes(parameterizedMapType, "put").get(1);
            }
        }
        throw new AssertionError((Object)("Unknown contribution type: " + (Object)((Object)contributionType)));
    }

    private ImmutableList<TypeMirror> methodParameterTypes(DeclaredType type, String methodName) {
        ImmutableList.Builder methodsForName = ImmutableList.builder();
        for (ExecutableElement method : ElementFilter.methodsIn(MoreElements.asType(type.asElement()).getEnclosedElements())) {
            if (!method.getSimpleName().contentEquals(methodName)) continue;
            methodsForName.add((Object)method);
        }
        ExecutableElement method = (ExecutableElement)Iterables.getOnlyElement((Iterable)methodsForName.build());
        return ImmutableList.copyOf(MoreTypes.asExecutable(this.types.asMemberOf(type, method)).getParameterTypes());
    }

    private TypeMirror methodParameterType(DeclaredType type, String methodName) {
        return (TypeMirror)Iterables.getOnlyElement(this.methodParameterTypes(type, methodName));
    }

    private TypeElement setElement() {
        return this.elements.getTypeElement(Set.class.getName());
    }

    private TypeElement mapElement() {
        return this.elements.getTypeElement(Map.class.getName());
    }

    private TypeMirror unboundedWildcard() {
        return this.types.getWildcardType(null, null);
    }
}

