/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.SetType;
import dagger.model.Key;
import java.util.Iterator;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor6;

final class BindingVariableNamer {
    private static final TypeVisitor<Void, StringBuilder> TYPE_NAMER = new SimpleTypeVisitor6<Void, StringBuilder>(){

        @Override
        public Void visitDeclared(DeclaredType declaredType, StringBuilder builder) {
            Element element = declaredType.asElement();
            if (ConfigurationAnnotations.isSubcomponentBuilder(element)) {
                builder.append(element.getEnclosingElement().getSimpleName());
            }
            builder.append(element.getSimpleName());
            Iterator<? extends TypeMirror> argumentIterator = declaredType.getTypeArguments().iterator();
            if (argumentIterator.hasNext()) {
                builder.append("Of");
                TypeMirror first = argumentIterator.next();
                first.accept(this, builder);
                while (argumentIterator.hasNext()) {
                    builder.append("And");
                    argumentIterator.next().accept(this, builder);
                }
            }
            return null;
        }

        @Override
        public Void visitPrimitive(PrimitiveType type, StringBuilder builder) {
            builder.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, type.toString()));
            return null;
        }

        @Override
        public Void visitArray(ArrayType type, StringBuilder builder) {
            type.getComponentType().accept(this, builder);
            builder.append("Array");
            return null;
        }
    };

    private BindingVariableNamer() {
    }

    static String name(Binding binding) {
        StringBuilder builder = new StringBuilder();
        Key key = binding.key();
        if (key.qualifier().isPresent()) {
            builder.append(((AnnotationMirror)key.qualifier().get()).getAnnotationType().asElement().getSimpleName());
        }
        TypeMirror type = BindingVariableNamer.typeToName(binding);
        type.accept(TYPE_NAMER, builder);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, builder.toString());
    }

    private static TypeMirror typeToName(Binding binding) {
        if (binding instanceof ContributionBinding && ((ContributionBinding)binding).contributionType().equals((Object)ContributionType.SET)) {
            return SetType.from(binding.key().type()).elementType();
        }
        return binding.key().type();
    }
}

