/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.AnyBindingMethodValidator;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;

final class BindingMethodProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final AnyBindingMethodValidator anyBindingMethodValidator;

    BindingMethodProcessingStep(Messager messager, AnyBindingMethodValidator anyBindingMethodValidator) {
        this.messager = messager;
        this.anyBindingMethodValidator = anyBindingMethodValidator;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return this.anyBindingMethodValidator.methodAnnotations();
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (ExecutableElement method : ElementFilter.methodsIn(elementsByAnnotation.values())) {
            Preconditions.checkArgument((boolean)this.anyBindingMethodValidator.isBindingMethod(method), (String)"%s is not annotated with any of %s", (Object)method, this.annotations());
            if (this.anyBindingMethodValidator.wasAlreadyValidated(method)) continue;
            this.anyBindingMethodValidator.validate(method).printMessagesTo(this.messager);
        }
        return ImmutableSet.of();
    }
}

