/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentBuilder;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementField;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.SubcomponentNames;
import dagger.internal.codegen.SubcomponentWriter;
import dagger.internal.codegen.UniqueNameSet;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class AbstractComponentWriter {
    protected final Elements elements;
    protected final DaggerTypes types;
    private final CompilerOptions compilerOptions;
    protected final BindingGraph graph;
    protected final SubcomponentNames subcomponentNames;
    private final ComponentBindingExpressions bindingExpressions;
    protected final ComponentRequirementFields componentRequirementFields;
    protected final GeneratedComponentModel generatedComponentModel;
    private final ComponentRequirementField.Factory componentRequirementFieldFactory;
    protected final MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
    private final OptionalFactories optionalFactories;
    private ComponentBuilder builder;
    private boolean done;
    private final ImmutableMap<ComponentRequirement, FieldSpec> builderFields;
    private static final int INITIALIZATIONS_PER_INITIALIZE_METHOD = 100;

    AbstractComponentWriter(DaggerTypes types, Elements elements, CompilerOptions compilerOptions, BindingGraph graph, GeneratedComponentModel generatedComponentModel, SubcomponentNames subcomponentNames, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementFields componentRequirementFields) {
        this.types = types;
        this.elements = elements;
        this.compilerOptions = compilerOptions;
        this.graph = graph;
        this.subcomponentNames = subcomponentNames;
        this.generatedComponentModel = generatedComponentModel;
        this.optionalFactories = optionalFactories;
        this.bindingExpressions = bindingExpressions;
        if (AbstractComponentWriter.hasBuilder(graph)) {
            this.builder = ComponentBuilder.create(generatedComponentModel.name(), graph, subcomponentNames, elements, types);
            this.builderFields = this.builder.builderFields();
        } else {
            this.builderFields = ImmutableMap.of();
        }
        this.componentRequirementFields = componentRequirementFields;
        this.componentRequirementFieldFactory = new ComponentRequirementField.Factory(generatedComponentModel, this.builderFields);
    }

    protected AbstractComponentWriter(AbstractComponentWriter parent, GeneratedComponentModel generatedComponentModel, BindingGraph graph, ComponentRequirementFields componentRequirementFields) {
        this(parent.types, parent.elements, parent.compilerOptions, graph, generatedComponentModel, parent.subcomponentNames, parent.optionalFactories, parent.bindingExpressions.forChildComponent(graph, generatedComponentModel, componentRequirementFields), componentRequirementFields);
    }

    final TypeSpec.Builder write() {
        Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"ComponentWriter has already been generated.");
        this.generatedComponentModel.addSupertype(this.graph.componentType());
        if (AbstractComponentWriter.hasBuilder(this.graph)) {
            this.addBuilder();
        }
        MoreElements.getLocalAndInheritedMethods(this.graph.componentDescriptor().componentDefinitionType(), this.types, this.elements).forEach(method -> this.generatedComponentModel.claimMethodName(method.getSimpleName()));
        this.addFactoryMethods();
        this.createComponentRequirementFields();
        this.addInterfaceMethods();
        this.addSubcomponents();
        this.addInitializeMethods();
        this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.CONSTRUCTOR, this.constructor.build());
        if (this.graph.componentDescriptor().kind().isTopLevel()) {
            this.optionalFactories.addMembers(this.generatedComponentModel);
        }
        this.done = true;
        return this.generatedComponentModel.generate();
    }

    private static boolean hasBuilder(BindingGraph graph) {
        ComponentDescriptor component = graph.componentDescriptor();
        return component.kind().isTopLevel() || component.builderSpec().isPresent();
    }

    private void addBuilder() {
        this.addBuilderClass(this.builder.typeSpec());
        this.constructor.addParameter((TypeName)this.builderName(), "builder", new Modifier[0]);
    }

    protected abstract void addBuilderClass(TypeSpec var1);

    protected final ClassName builderName() {
        return this.builder.name();
    }

    protected abstract void addFactoryMethods();

    private void createComponentRequirementFields() {
        this.builderFields.keySet().stream().map(this.componentRequirementFieldFactory::forBuilderField).forEach(this.componentRequirementFields::add);
    }

    private void addInterfaceMethods() {
        HashSet interfaceMethodSignatures = Sets.newHashSet();
        DeclaredType componentType = MoreTypes.asDeclared(this.graph.componentType().asType());
        for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : this.graph.componentDescriptor().componentMethods()) {
            if (!componentMethod.dependencyRequest().isPresent()) continue;
            ExecutableElement methodElement = componentMethod.methodElement();
            ExecutableType requestType = MoreTypes.asExecutable(this.types.asMemberOf(componentType, methodElement));
            MethodSignature signature = MethodSignature.fromExecutableType(methodElement.getSimpleName().toString(), requestType);
            if (!interfaceMethodSignatures.add(signature)) continue;
            MethodSpec.Builder interfaceMethod = MethodSpec.overriding((ExecutableElement)methodElement, (DeclaredType)componentType, (Types)this.types);
            interfaceMethod.addCode(this.bindingExpressions.getComponentMethodImplementation(componentMethod, this.generatedComponentModel.name()));
            this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.COMPONENT_METHOD, interfaceMethod.build());
        }
    }

    private void addSubcomponents() {
        for (BindingGraph subgraph : this.graph.subgraphs()) {
            this.generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.SUBCOMPONENT, new SubcomponentWriter(this, subgraph).write().build());
        }
    }

    private void addInitializeMethods() {
        List partitions = Lists.partition(this.generatedComponentModel.getInitializations(), (int)100);
        UniqueNameSet methodNames = new UniqueNameSet();
        for (List partition : partitions) {
            String methodName = methodNames.getUniqueName("initialize");
            MethodSpec.Builder initializeMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).addCode(CodeBlocks.concat(partition));
            if (AbstractComponentWriter.hasBuilder(this.graph)) {
                initializeMethod.addParameter((TypeName)this.builderName(), "builder", new Modifier[]{Modifier.FINAL});
                this.constructor.addStatement("$L(builder)", new Object[]{methodName});
            } else {
                this.constructor.addStatement("$L()", new Object[]{methodName});
            }
            this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.INITIALIZE_METHOD, initializeMethod.build());
        }
    }
}

