/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AbstractComponentWriter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.TypeSpecs;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

final class SubcomponentWriter
extends AbstractComponentWriter {
    private final AbstractComponentWriter parent;
    private final Optional<ComponentDescriptor.ComponentMethodDescriptor> subcomponentFactoryMethod;

    SubcomponentWriter(AbstractComponentWriter parent, Optional<ComponentDescriptor.ComponentMethodDescriptor> subcomponentFactoryMethod, BindingGraph subgraph) {
        super(parent, SubcomponentWriter.subcomponentName(parent, subgraph), subgraph);
        this.parent = parent;
        this.subcomponentFactoryMethod = subcomponentFactoryMethod;
    }

    private static ClassName subcomponentName(AbstractComponentWriter parent, BindingGraph subgraph) {
        return parent.name.nestedClass((String)parent.subcomponentNames.get((Object)subgraph.componentDescriptor()) + "Impl");
    }

    @Override
    protected AbstractComponentWriter.InitializationState getInitializationState(BindingKey bindingKey) {
        AbstractComponentWriter.InitializationState initializationState = super.getInitializationState(bindingKey);
        return initializationState.equals((Object)AbstractComponentWriter.InitializationState.UNINITIALIZED) ? this.parent.getInitializationState(bindingKey) : initializationState;
    }

    @Override
    protected Optional<CodeBlock> getOrCreateComponentRequirementFieldExpression(ComponentRequirement componentRequirement) {
        Optional<CodeBlock> expression = super.getOrCreateComponentRequirementFieldExpression(componentRequirement);
        return expression.isPresent() ? expression : this.parent.getOrCreateComponentRequirementFieldExpression(componentRequirement);
    }

    @Override
    public MemberSelect getMemberSelect(BindingKey key) {
        MemberSelect memberSelect = super.getMemberSelect(key);
        return memberSelect == null ? this.parent.getMemberSelect(key) : memberSelect;
    }

    @Override
    protected CodeBlock getReferenceReleasingProviderManagerExpression(Scope scope) {
        return this.parent.getReferenceReleasingProviderManagerExpression(scope);
    }

    private ExecutableType resolvedSubcomponentFactoryMethod() {
        com.google.common.base.Preconditions.checkState((boolean)this.subcomponentFactoryMethod.isPresent(), (String)"%s does not have a factory method for %s", (Object)this.parent.graph.componentType(), (Object)this.graph.componentType());
        return MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(this.parent.graph.componentType().asType()), this.subcomponentFactoryMethod.get().methodElement()));
    }

    @Override
    protected void decorateComponent() {
        this.component.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        TypeSpecs.addSupertype(this.component, MoreTypes.asTypeElement(this.graph.componentDescriptor().builderSpec().isPresent() ? this.graph.componentDescriptor().builderSpec().get().componentType() : this.resolvedSubcomponentFactoryMethod().getReturnType()));
    }

    @Override
    protected void addBuilder() {
        if (this.graph.componentDescriptor().builderSpec().isPresent()) {
            super.addBuilder();
        }
    }

    @Override
    protected ClassName builderName() {
        return this.name.peerClass((String)this.subcomponentNames.get((Object)this.graph.componentDescriptor()) + "Builder");
    }

    @Override
    protected TypeSpec.Builder createBuilder(String builderSimpleName) {
        Verify.verify((boolean)this.graph.componentDescriptor().builderSpec().isPresent());
        return TypeSpec.classBuilder((String)builderSimpleName);
    }

    @Override
    protected void addBuilderClass(TypeSpec builder) {
        this.parent.component.addType(builder);
    }

    @Override
    protected void addFactoryMethods() {
        if (!this.subcomponentFactoryMethod.isPresent() || !this.subcomponentFactoryMethod.get().kind().isSubcomponentKind()) {
            return;
        }
        MethodSpec.Builder componentMethod = MethodSpec.methodBuilder((String)this.subcomponentFactoryMethod.get().methodElement().getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
        ExecutableType resolvedMethod = this.resolvedSubcomponentFactoryMethod();
        componentMethod.returns(ClassName.get((TypeMirror)resolvedMethod.getReturnType()));
        this.writeSubcomponentWithoutBuilder(componentMethod, resolvedMethod);
        this.parent.component.addMethod(componentMethod.build());
    }

    private void writeSubcomponentWithoutBuilder(MethodSpec.Builder componentMethod, ExecutableType resolvedMethod) {
        ImmutableList.Builder subcomponentConstructorParameters = ImmutableList.builder();
        List<? extends VariableElement> params = this.subcomponentFactoryMethod.get().methodElement().getParameters();
        List<? extends TypeMirror> paramTypes = resolvedMethod.getParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            VariableElement moduleVariable = params.get(i);
            TypeElement moduleTypeElement = MoreTypes.asTypeElement(paramTypes.get(i));
            ComponentRequirement componentRequirement = ComponentRequirement.forModule(moduleTypeElement.asType());
            TypeName moduleType = TypeName.get((TypeMirror)paramTypes.get(i));
            componentMethod.addParameter(moduleType, moduleVariable.getSimpleName().toString(), new Modifier[0]);
            if (this.componentContributionFields.containsKey(componentRequirement)) continue;
            String preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleTypeElement.getSimpleName().toString());
            FieldSpec contributionField = this.componentField((TypeName)ClassName.get((TypeElement)moduleTypeElement), preferredModuleName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            this.component.addField(contributionField);
            String actualModuleName = contributionField.name;
            this.constructor.addParameter(moduleType, actualModuleName, new Modifier[0]).addStatement("this.$1L = $2T.checkNotNull($1L)", new Object[]{actualModuleName, Preconditions.class});
            MemberSelect moduleSelect = MemberSelect.localField(this.name, actualModuleName);
            this.componentContributionFields.put(componentRequirement, moduleSelect);
            subcomponentConstructorParameters.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{moduleVariable.getSimpleName()}));
        }
        Sets.SetView uninitializedModules = Sets.difference(this.graph.componentRequirements(), this.componentContributionFields.keySet());
        for (ComponentRequirement componentRequirement : uninitializedModules) {
            com.google.common.base.Preconditions.checkState((boolean)componentRequirement.kind().equals((Object)ComponentRequirement.Kind.MODULE));
            TypeElement moduleType = componentRequirement.typeElement();
            String preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleType.getSimpleName().toString());
            FieldSpec contributionField = this.componentField((TypeName)ClassName.get((TypeElement)moduleType), preferredModuleName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            this.component.addField(contributionField);
            String actualModuleName = contributionField.name;
            this.constructor.addStatement("this.$L = new $T()", new Object[]{actualModuleName, ClassName.get((TypeElement)moduleType)});
            MemberSelect moduleSelect = MemberSelect.localField(this.name, actualModuleName);
            this.componentContributionFields.put(componentRequirement, moduleSelect);
        }
        componentMethod.addStatement("return new $T($L)", new Object[]{this.name, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)subcomponentConstructorParameters.build())});
    }
}

