/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

final class ComponentHierarchyValidator {
    private final CompilerOptions compilerOptions;
    private final Elements elements;

    ComponentHierarchyValidator(CompilerOptions compilerOptions, Elements elements) {
        this.compilerOptions = compilerOptions;
        this.elements = elements;
    }

    ValidationReport<TypeElement> validate(ComponentDescriptor componentDescriptor) {
        ValidationReport.Builder<TypeElement> report = ValidationReport.about(componentDescriptor.componentDefinitionType());
        this.validateSubcomponentMethods(report, componentDescriptor, (ImmutableMap<TypeElement, TypeElement>)Maps.toMap(componentDescriptor.transitiveModuleTypes(), (Function)Functions.constant((Object)componentDescriptor.componentDefinitionType())));
        if (this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent()) {
            this.validateScopeHierarchy(report, componentDescriptor, (SetMultimap<ComponentDescriptor, Scope>)LinkedHashMultimap.create());
        }
        return report.build();
    }

    private void validateSubcomponentMethods(ValidationReport.Builder<?> report, ComponentDescriptor componentDescriptor, ImmutableMap<TypeElement, TypeElement> existingModuleToOwners) {
        for (Map.Entry subcomponentEntry : componentDescriptor.subcomponentsByFactoryMethod().entrySet()) {
            ComponentDescriptor.ComponentMethodDescriptor subcomponentMethodDescriptor = (ComponentDescriptor.ComponentMethodDescriptor)subcomponentEntry.getKey();
            ComponentDescriptor subcomponentDescriptor = (ComponentDescriptor)subcomponentEntry.getValue();
            for (VariableElement variableElement : subcomponentMethodDescriptor.methodElement().getParameters()) {
                TypeElement moduleType = MoreTypes.asTypeElement(variableElement.asType());
                TypeElement originatingComponent = (TypeElement)existingModuleToOwners.get((Object)moduleType);
                if (originatingComponent == null) continue;
                report.addError(String.format("%s is present in %s. A subcomponent cannot use an instance of a module that differs from its parent.", moduleType.getSimpleName(), originatingComponent.getQualifiedName()), variableElement);
            }
            this.validateSubcomponentMethods(report, subcomponentDescriptor, (ImmutableMap<TypeElement, TypeElement>)new ImmutableMap.Builder().putAll(existingModuleToOwners).putAll((Map)Maps.toMap((Iterable)Sets.difference(subcomponentDescriptor.transitiveModuleTypes(), (Set)existingModuleToOwners.keySet()), (Function)Functions.constant((Object)subcomponentDescriptor.componentDefinitionType()))).build());
        }
    }

    private void validateScopeHierarchy(ValidationReport.Builder<TypeElement> report, ComponentDescriptor subject, SetMultimap<ComponentDescriptor, Scope> scopesByComponent) {
        scopesByComponent.putAll((Object)subject, subject.scopes());
        for (ComponentDescriptor child : subject.subcomponents()) {
            this.validateScopeHierarchy(report, child, scopesByComponent);
        }
        scopesByComponent.removeAll((Object)subject);
        Predicate subjectScopes = subject.kind().isProducer() ? Predicates.and((Predicate)Predicates.in(subject.scopes()), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)Scope.productionScope(this.elements)))) : Predicates.in(subject.scopes());
        SetMultimap overlappingScopes = Multimaps.filterValues(scopesByComponent, (Predicate)subjectScopes);
        if (!overlappingScopes.isEmpty()) {
            StringBuilder error = new StringBuilder().append(subject.componentDefinitionType().getQualifiedName()).append(" has conflicting scopes:");
            for (Map.Entry entry : overlappingScopes.entries()) {
                Scope scope = (Scope)entry.getValue();
                error.append("\n  ").append(((ComponentDescriptor)entry.getKey()).componentDefinitionType().getQualifiedName()).append(" also has ").append(scope.getReadableSource());
            }
            report.addItem(error.toString(), this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), subject.componentDefinitionType());
        }
    }
}

