/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.KeyFormatter;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class BindingDeclarationFormatter
extends Formatter<BindingDeclaration> {
    private static final ImmutableSet<TypeKind> FORMATTABLE_ELEMENT_TYPE_KINDS = Sets.immutableEnumSet((Enum)TypeKind.EXECUTABLE, (Enum[])new TypeKind[]{TypeKind.DECLARED});
    private static final ImmutableSet<ContributionBinding.Kind> FORMATTABLE_ELEMENTLESS_BINDING_KINDS = Sets.immutableEnumSet((Enum)ContributionBinding.Kind.SYNTHETIC_RELEASABLE_REFERENCE_MANAGER, (Enum[])new ContributionBinding.Kind[]{ContributionBinding.Kind.SYNTHETIC_RELEASABLE_REFERENCE_MANAGERS});
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final KeyFormatter keyFormatter;

    BindingDeclarationFormatter(MethodSignatureFormatter methodSignatureFormatter, KeyFormatter keyFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.keyFormatter = keyFormatter;
    }

    boolean canFormat(BindingDeclaration bindingDeclaration) {
        if (bindingDeclaration instanceof SubcomponentDeclaration) {
            return true;
        }
        if (bindingDeclaration.bindingElement().isPresent()) {
            return FORMATTABLE_ELEMENT_TYPE_KINDS.contains((Object)bindingDeclaration.bindingElement().get().asType().getKind());
        }
        if (bindingDeclaration instanceof ContributionBinding) {
            ContributionBinding contributionBinding = (ContributionBinding)bindingDeclaration;
            return FORMATTABLE_ELEMENTLESS_BINDING_KINDS.contains((Object)contributionBinding.bindingKind());
        }
        return false;
    }

    @Override
    public String format(BindingDeclaration bindingDeclaration) {
        if (bindingDeclaration instanceof SubcomponentDeclaration) {
            return this.formatSubcomponentDeclaration((SubcomponentDeclaration)bindingDeclaration);
        }
        if (bindingDeclaration instanceof ContributionBinding) {
            ContributionBinding binding = (ContributionBinding)bindingDeclaration;
            switch (binding.bindingKind()) {
                case SYNTHETIC_RELEASABLE_REFERENCE_MANAGER: {
                    return String.format("binding for %s from the scope declaration", ErrorMessages.stripCommonTypePrefixes(this.keyFormatter.format(binding.key())));
                }
                case SYNTHETIC_RELEASABLE_REFERENCE_MANAGERS: {
                    return String.format("Dagger-generated binding for %s", ErrorMessages.stripCommonTypePrefixes(this.keyFormatter.format(binding.key())));
                }
            }
        }
        Preconditions.checkArgument((boolean)bindingDeclaration.bindingElement().isPresent(), (String)"Cannot format bindings without source elements: %s", (Object)bindingDeclaration);
        Element bindingElement = bindingDeclaration.bindingElement().get();
        switch (bindingElement.asType().getKind()) {
            case EXECUTABLE: {
                return this.methodSignatureFormatter.format(MoreElements.asExecutable(bindingElement), bindingDeclaration.contributingModule().map(module -> MoreTypes.asDeclared(module.asType())));
            }
            case DECLARED: {
                return ErrorMessages.stripCommonTypePrefixes(bindingElement.asType().toString());
            }
        }
        throw new IllegalArgumentException("Formatting unsupported for element: " + bindingElement);
    }

    private String formatSubcomponentDeclaration(SubcomponentDeclaration subcomponentDeclaration) {
        ImmutableList<TypeMirror> moduleSubcomponents = ConfigurationAnnotations.getModuleSubcomponents(subcomponentDeclaration.moduleAnnotation());
        int index = Iterables.indexOf(moduleSubcomponents, (Predicate)MoreTypes.equivalence().equivalentTo((Object)subcomponentDeclaration.subcomponentType().asType()));
        StringBuilder annotationValue = new StringBuilder();
        if (moduleSubcomponents.size() != 1) {
            annotationValue.append("{");
        }
        annotationValue.append(this.formatArgumentInList(index, moduleSubcomponents.size(), subcomponentDeclaration.subcomponentType().getQualifiedName() + ".class"));
        if (moduleSubcomponents.size() != 1) {
            annotationValue.append("}");
        }
        return String.format("@%s(subcomponents = %s) for %s", MoreAnnotationMirrors.simpleName(subcomponentDeclaration.moduleAnnotation()), annotationValue, subcomponentDeclaration.contributingModule().get());
    }
}

