/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentProvider;
import android.content.Context;
import android.util.Log;
import dagger.android.AndroidInjector;
import dagger.android.HasActivityInjector;
import dagger.android.HasAndroidInjector;
import dagger.android.HasBroadcastReceiverInjector;
import dagger.android.HasContentProviderInjector;
import dagger.android.HasFragmentInjector;
import dagger.android.HasServiceInjector;
import dagger.internal.Preconditions;

public final class AndroidInjection {
    private static final String TAG = "dagger.android";

    public static void inject(Activity activity) {
        AndroidInjector<Object> injector;
        Preconditions.checkNotNull((Object)activity, (String)"activity");
        Application application = activity.getApplication();
        if (application instanceof HasAndroidInjector) {
            injector = ((HasAndroidInjector)application).androidInjector();
            Preconditions.checkNotNull(injector, (String)"%s.androidInjector() returned null", application.getClass());
        } else if (application instanceof HasActivityInjector) {
            injector = ((HasActivityInjector)application).activityInjector();
            Preconditions.checkNotNull(injector, (String)"%s.activityInjector() returned null", application.getClass());
        } else {
            throw new RuntimeException(String.format("%s does not implement %s or %s", application.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName(), HasActivityInjector.class.getCanonicalName()));
        }
        injector.inject(activity);
    }

    public static void inject(Fragment fragment) {
        AndroidInjector<Object> injector;
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        Object hasInjector = AndroidInjection.findHasFragmentInjector(fragment);
        if (hasInjector instanceof HasAndroidInjector) {
            injector = ((HasAndroidInjector)hasInjector).androidInjector();
            Preconditions.checkNotNull(injector, (String)"%s.androidInjector() returned null", hasInjector.getClass());
        } else if (hasInjector instanceof HasFragmentInjector) {
            injector = ((HasFragmentInjector)hasInjector).fragmentInjector();
            Preconditions.checkNotNull(injector, (String)"%s.fragmentInjector() returned null", hasInjector.getClass());
        } else {
            throw new RuntimeException(String.format("%s does not implement %s or %s", hasInjector.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName(), HasFragmentInjector.class.getCanonicalName()));
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasInjector.getClass().getCanonicalName()));
        }
        injector.inject(fragment);
    }

    private static Object findHasFragmentInjector(Fragment fragment) {
        Fragment parentFragment = fragment;
        while ((parentFragment = parentFragment.getParentFragment()) != null) {
            if (!(parentFragment instanceof HasAndroidInjector) && !(parentFragment instanceof HasFragmentInjector)) continue;
            return parentFragment;
        }
        Activity activity = fragment.getActivity();
        if (activity instanceof HasAndroidInjector || activity instanceof HasFragmentInjector) {
            return activity;
        }
        Application application = activity.getApplication();
        if (application instanceof HasAndroidInjector || application instanceof HasFragmentInjector) {
            return application;
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    public static void inject(Service service) {
        AndroidInjector<Object> injector;
        Preconditions.checkNotNull((Object)service, (String)"service");
        Application application = service.getApplication();
        if (application instanceof HasAndroidInjector) {
            injector = ((HasAndroidInjector)application).androidInjector();
            Preconditions.checkNotNull(injector, (String)"%s.androidInjector() returned null", application.getClass());
        } else if (application instanceof HasServiceInjector) {
            injector = ((HasServiceInjector)application).serviceInjector();
            Preconditions.checkNotNull(injector, (String)"%s.serviceInjector() returned null", application.getClass());
        } else {
            throw new RuntimeException(String.format("%s does not implement %s or %s", application.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName(), HasServiceInjector.class.getCanonicalName()));
        }
        injector.inject(service);
    }

    public static void inject(BroadcastReceiver broadcastReceiver, Context context) {
        AndroidInjector<Object> injector;
        Preconditions.checkNotNull((Object)broadcastReceiver, (String)"broadcastReceiver");
        Preconditions.checkNotNull((Object)context, (String)"context");
        Application application = (Application)context.getApplicationContext();
        if (application instanceof HasAndroidInjector) {
            injector = ((HasAndroidInjector)application).androidInjector();
            Preconditions.checkNotNull(injector, (String)"%s.androidInjector() returned null", application.getClass());
        } else if (application instanceof HasBroadcastReceiverInjector) {
            injector = ((HasBroadcastReceiverInjector)application).broadcastReceiverInjector();
            Preconditions.checkNotNull(injector, (String)"%s.broadcastReceiverInjector() returned null", application.getClass());
        } else {
            throw new RuntimeException(String.format("%s does not implement %s or %s", application.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName(), HasBroadcastReceiverInjector.class.getCanonicalName()));
        }
        injector.inject(broadcastReceiver);
    }

    public static void inject(ContentProvider contentProvider) {
        AndroidInjector<Object> injector;
        Preconditions.checkNotNull((Object)contentProvider, (String)"contentProvider");
        Application application = (Application)contentProvider.getContext().getApplicationContext();
        if (application instanceof HasAndroidInjector) {
            injector = ((HasAndroidInjector)application).androidInjector();
            Preconditions.checkNotNull(injector, (String)"%s.androidInjector() returned null", application.getClass());
        } else if (application instanceof HasContentProviderInjector) {
            injector = ((HasContentProviderInjector)application).contentProviderInjector();
            Preconditions.checkNotNull(injector, (String)"%s.contentProviderInjector() returned null", application.getClass());
        } else {
            throw new RuntimeException(String.format("%s does not implement %s or %s", application.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName(), HasBroadcastReceiverInjector.class.getCanonicalName()));
        }
        injector.inject(contentProvider);
    }

    private AndroidInjection() {
    }
}

