/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.support;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.support.HasDispatchingSupportFragmentInjector;
import dagger.internal.Preconditions;

public final class AndroidSupportInjection {
    private static final String TAG = "dagger.android.support";

    public static void inject(Fragment fragment) {
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        HasDispatchingSupportFragmentInjector hasDispatchingSupportFragmentInjector = AndroidSupportInjection.findHasFragmentInjector(fragment);
        Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasDispatchingSupportFragmentInjector.getClass().getCanonicalName()));
        DispatchingAndroidInjector<Fragment> fragmentInjector = hasDispatchingSupportFragmentInjector.supportFragmentInjector();
        Preconditions.checkNotNull(fragmentInjector, (String)"%s.supportFragmentInjector() returned null", (Object)hasDispatchingSupportFragmentInjector.getClass().getCanonicalName());
        fragmentInjector.inject((Object)fragment);
    }

    private static HasDispatchingSupportFragmentInjector findHasFragmentInjector(Fragment fragment) {
        Fragment parentFragment = fragment;
        while ((parentFragment = parentFragment.getParentFragment()) != null) {
            if (!(parentFragment instanceof HasDispatchingSupportFragmentInjector)) continue;
            return (HasDispatchingSupportFragmentInjector)parentFragment;
        }
        FragmentActivity activity = fragment.getActivity();
        if (activity instanceof HasDispatchingSupportFragmentInjector) {
            return (HasDispatchingSupportFragmentInjector)activity;
        }
        if (activity.getApplication() instanceof HasDispatchingSupportFragmentInjector) {
            return (HasDispatchingSupportFragmentInjector)activity.getApplication();
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    private AndroidSupportInjection() {
    }
}

