/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import dagger.Binds;
import dagger.android.AndroidInjector;
import dagger.android.processor.AndroidMapKeys;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class AndroidMapKeyValidator
implements BasicAnnotationProcessor.ProcessingStep {
    private final Elements elements;
    private final Types types;
    private final Messager messager;

    AndroidMapKeyValidator(Elements elements, Types types, Messager messager) {
        this.elements = elements;
        this.types = types;
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return AndroidMapKeys.annotationsAndFrameworkTypes(this.elements).keySet();
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        elementsByAnnotation.forEach((annotation, element) -> this.validateMethod((Class<? extends Annotation>)annotation, MoreElements.asExecutable(element)));
        return ImmutableSet.of();
    }

    private void validateMethod(Class<? extends Annotation> annotation, ExecutableElement method) {
        SuppressWarnings suppressedWarnings;
        if (!AnnotationMirrors.getAnnotatedAnnotations(method, Qualifier.class).isEmpty()) {
            return;
        }
        TypeMirror returnType = method.getReturnType();
        if (!this.types.isAssignable(this.types.erasure(returnType), this.factoryElement().asType())) {
            return;
        }
        TypeMirror frameworkType = (TypeMirror)AndroidMapKeys.annotationsAndFrameworkTypes(this.elements).get(annotation);
        if (!(AnnotationMirrors.getAnnotatedAnnotations(method, Scope.class).isEmpty() || (suppressedWarnings = method.getAnnotation(SuppressWarnings.class)) != null && ImmutableSet.copyOf((Object[])suppressedWarnings.value()).contains((Object)"dagger.android.ScopedInjectorFactory"))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s bindings should not be scoped. Scoping this method may leak instances of %s. ", AndroidInjector.Factory.class.getCanonicalName(), frameworkType), method);
        }
        DeclaredType intendedReturnType = this.injectorFactoryOf(this.types.getWildcardType(frameworkType, null));
        if (!MoreTypes.equivalence().equivalent((Object)returnType, (Object)intendedReturnType)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s methods should bind %s, not %s. See https://google.github.io/dagger/android", annotation.getCanonicalName(), intendedReturnType, returnType), method);
        }
        if (MoreElements.isAnnotationPresent(method, Binds.class) && method.getParameters().size() == 1) {
            this.validateMapKeyMatchesBindsParameter(annotation, method);
        }
    }

    private void validateMapKeyMatchesBindsParameter(Class<? extends Annotation> annotation, ExecutableElement method) {
        AnnotationMirror annotationMirror;
        TypeMirror mapKeyValue;
        TypeMirror parameterType = ((VariableElement)Iterables.getOnlyElement(method.getParameters())).asType();
        if (!this.types.isAssignable(parameterType, this.injectorFactoryOf(mapKeyValue = (TypeMirror)AnnotationMirrors.getAnnotationValue(annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(method, annotation).get(), "value").getValue()))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s does not implement AndroidInjector<%s>", parameterType, mapKeyValue), method, annotationMirror);
        }
    }

    private DeclaredType injectorFactoryOf(TypeMirror implementationType) {
        return this.types.getDeclaredType(this.factoryElement(), implementationType);
    }

    private TypeElement factoryElement() {
        return this.elements.getTypeElement(AndroidInjector.Factory.class.getCanonicalName());
    }
}

