/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.subtle.Poly1305;
import com.google.crypto.tink.subtle.Snuffle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import javax.crypto.AEADBadTagException;

abstract class SnufflePoly1305
implements Aead {
    private final byte[] key;
    private final Snuffle snuffle;
    private final Snuffle macKeysnuffle;

    SnufflePoly1305(byte[] key) throws InvalidKeyException {
        this.key = (byte[])key.clone();
        this.snuffle = this.createSnuffleInstance(key, 1);
        this.macKeysnuffle = this.createSnuffleInstance(key, 0);
    }

    abstract Snuffle createSnuffleInstance(byte[] var1, int var2) throws InvalidKeyException;

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        if (plaintext.length > Integer.MAX_VALUE - this.snuffle.nonceSizeInBytes() - 16) {
            throw new GeneralSecurityException("plaintext too long");
        }
        ByteBuffer ciphertext = ByteBuffer.allocate(plaintext.length + this.snuffle.nonceSizeInBytes() + 16);
        this.encrypt(ciphertext, plaintext, associatedData);
        return ciphertext.array();
    }

    private void encrypt(ByteBuffer output, byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        if (output.remaining() < plaintext.length + this.snuffle.nonceSizeInBytes() + 16) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        int firstPosition = output.position();
        this.snuffle.encrypt(output, plaintext);
        output.position(firstPosition);
        byte[] nonce = new byte[this.snuffle.nonceSizeInBytes()];
        output.get(nonce);
        output.limit(output.limit() - 16);
        byte[] aad = associatedData;
        if (aad == null) {
            aad = new byte[]{};
        }
        byte[] tag = Poly1305.computeMac(this.getMacKey(nonce), SnufflePoly1305.macDataRfc7539(aad, output));
        output.limit(output.limit() + 16);
        output.put(tag);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        return this.decrypt(ByteBuffer.wrap(ciphertext), associatedData);
    }

    private byte[] decrypt(ByteBuffer ciphertext, byte[] associatedData) throws GeneralSecurityException {
        if (ciphertext.remaining() < this.snuffle.nonceSizeInBytes() + 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        int firstPosition = ciphertext.position();
        byte[] tag = new byte[16];
        ciphertext.position(ciphertext.limit() - 16);
        ciphertext.get(tag);
        ciphertext.position(firstPosition);
        ciphertext.limit(ciphertext.limit() - 16);
        byte[] nonce = new byte[this.snuffle.nonceSizeInBytes()];
        ciphertext.get(nonce);
        byte[] aad = associatedData;
        if (aad == null) {
            aad = new byte[]{};
        }
        try {
            Poly1305.verifyMac(this.getMacKey(nonce), SnufflePoly1305.macDataRfc7539(aad, ciphertext), tag);
        }
        catch (GeneralSecurityException ex) {
            throw new AEADBadTagException(ex.toString());
        }
        ciphertext.position(firstPosition);
        return this.snuffle.decrypt(ciphertext);
    }

    static byte[] macDataRfc7539(byte[] aad, ByteBuffer ciphertext) {
        int aadPaddedLen = aad.length % 16 == 0 ? aad.length : aad.length + 16 - aad.length % 16;
        int ciphertextLen = ciphertext.remaining();
        int ciphertextPaddedLen = ciphertextLen % 16 == 0 ? ciphertextLen : ciphertextLen + 16 - ciphertextLen % 16;
        ByteBuffer macData = ByteBuffer.allocate(aadPaddedLen + ciphertextPaddedLen + 16).order(ByteOrder.LITTLE_ENDIAN);
        macData.put(aad);
        macData.position(aadPaddedLen);
        macData.put(ciphertext);
        macData.position(aadPaddedLen + ciphertextPaddedLen);
        macData.putLong(aad.length);
        macData.putLong(ciphertextLen);
        return macData.array();
    }

    private byte[] getMacKey(byte[] nonce) throws InvalidKeyException {
        ByteBuffer firstBlock = this.macKeysnuffle.getKeyStreamBlock(nonce, 0);
        byte[] result = new byte[32];
        firstBlock.get(result);
        return result;
    }
}

