/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.ImmutableByteArray;
import com.google.crypto.tink.subtle.IndCpaCipher;
import com.google.crypto.tink.subtle.Random;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

abstract class Snuffle
implements IndCpaCipher {
    public static final int BLOCK_SIZE_IN_INTS = 16;
    public static final int BLOCK_SIZE_IN_BYTES = 64;
    public static final int KEY_SIZE_IN_INTS = 8;
    public static final int KEY_SIZE_IN_BYTES = 32;
    static final int[] SIGMA = Snuffle.toIntArray(ByteBuffer.wrap(new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107}));
    final ImmutableByteArray key;
    private final int initialCounter;

    abstract ByteBuffer getKeyStreamBlock(byte[] var1, int var2);

    abstract int nonceSizeInBytes();

    Snuffle(byte[] key, int initialCounter) throws InvalidKeyException {
        if (key.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.key = ImmutableByteArray.of(key);
        this.initialCounter = initialCounter;
    }

    @Override
    public byte[] encrypt(byte[] plaintext) throws GeneralSecurityException {
        if (plaintext.length > Integer.MAX_VALUE - this.nonceSizeInBytes()) {
            throw new GeneralSecurityException("plaintext too long");
        }
        ByteBuffer ciphertext = ByteBuffer.allocate(this.nonceSizeInBytes() + plaintext.length);
        this.encrypt(ciphertext, plaintext);
        return ciphertext.array();
    }

    void encrypt(ByteBuffer output, byte[] plaintext) throws GeneralSecurityException {
        if (output.remaining() - this.nonceSizeInBytes() < plaintext.length) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        byte[] nonce = Random.randBytes(this.nonceSizeInBytes());
        output.put(nonce);
        this.process(nonce, output, ByteBuffer.wrap(plaintext));
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) throws GeneralSecurityException {
        return this.decrypt(ByteBuffer.wrap(ciphertext));
    }

    byte[] decrypt(ByteBuffer ciphertext) throws GeneralSecurityException {
        if (ciphertext.remaining() < this.nonceSizeInBytes()) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        byte[] nonce = new byte[this.nonceSizeInBytes()];
        ciphertext.get(nonce);
        ByteBuffer plaintext = ByteBuffer.allocate(ciphertext.remaining());
        this.process(nonce, plaintext, ciphertext);
        return plaintext.array();
    }

    private void process(byte[] nonce, ByteBuffer output, ByteBuffer input) throws GeneralSecurityException {
        int length = input.remaining();
        int numBlocks = length / 64 + 1;
        for (int i = 0; i < numBlocks; ++i) {
            ByteBuffer keyStreamBlock = this.getKeyStreamBlock(nonce, i + this.initialCounter);
            if (i == numBlocks - 1) {
                Bytes.xor(output, input, keyStreamBlock, length % 64);
                continue;
            }
            Bytes.xor(output, input, keyStreamBlock, 64);
        }
    }

    static int rotateLeft(int x, int y) {
        return x << y | x >>> -y;
    }

    static int[] toIntArray(ByteBuffer in) {
        IntBuffer intBuffer = in.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] ret = new int[intBuffer.remaining()];
        intBuffer.get(ret);
        return ret;
    }
}

