/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.signature.EcdsaVerifyKeyManager;
import com.google.crypto.tink.signature.Ed25519PublicKeyManager;
import java.security.GeneralSecurityException;

class PublicKeyVerifyCatalogue
implements Catalogue<PublicKeyVerify> {
    @Override
    public KeyManager<PublicKeyVerify> getKeyManager(String typeUrl, String primitiveName, int minVersion) throws GeneralSecurityException {
        KeyManager<PublicKeyVerify> keyManager;
        switch (primitiveName.toLowerCase()) {
            case "publickeyverify": {
                keyManager = this.publicKeyVerifyKeyManager(typeUrl);
                break;
            }
            default: {
                throw new GeneralSecurityException(String.format("No support for primitive '%s'.", primitiveName));
            }
        }
        if (keyManager.getVersion() < minVersion) {
            throw new GeneralSecurityException(String.format("No key manager for key type '%s' with version at least %d.", typeUrl, minVersion));
        }
        return keyManager;
    }

    private KeyManager<PublicKeyVerify> publicKeyVerifyKeyManager(String typeUrl) throws GeneralSecurityException {
        switch (typeUrl) {
            case "type.googleapis.com/google.crypto.tink.EcdsaPublicKey": {
                return new EcdsaVerifyKeyManager();
            }
            case "type.googleapis.com/google.crypto.tink.Ed25519PublicKey": {
                return new Ed25519PublicKeyManager();
            }
        }
        throw new GeneralSecurityException(String.format("No support for primitive 'PublicKeyVerify' with key type '%s'.", typeUrl));
    }
}

