/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.subtle.Hex;
import java.io.IOException;

public final class SharedPrefKeysetWriter
implements KeysetWriter {
    private final SharedPreferences.Editor editor;
    private final String keysetName;

    public SharedPrefKeysetWriter(Context context, String keysetName, String prefFileName) {
        if (keysetName == null) {
            throw new IllegalArgumentException("keysetName cannot be null");
        }
        this.keysetName = keysetName;
        Context appContext = context.getApplicationContext();
        this.editor = prefFileName == null ? PreferenceManager.getDefaultSharedPreferences((Context)appContext).edit() : appContext.getSharedPreferences(prefFileName, 0).edit();
    }

    @Override
    public void write(Keyset keyset) throws IOException {
        this.editor.putString(this.keysetName, Hex.encode(keyset.toByteArray())).apply();
    }

    @Override
    public void write(EncryptedKeyset keyset) throws IOException {
        this.editor.putString(this.keysetName, Hex.encode(keyset.toByteArray())).apply();
    }
}

