/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.subtle.Hex;
import java.io.IOException;

public final class SharedPrefKeysetReader
implements KeysetReader {
    private final SharedPreferences sharedPreferences;
    private final String keysetName;

    public SharedPrefKeysetReader(Context context, String keysetName, String prefFilename) throws IOException {
        if (keysetName == null) {
            throw new IllegalArgumentException("keysetName cannot be null");
        }
        this.keysetName = keysetName;
        Context appContext = context.getApplicationContext();
        this.sharedPreferences = prefFilename == null ? PreferenceManager.getDefaultSharedPreferences((Context)appContext) : appContext.getSharedPreferences(prefFilename, 0);
    }

    private byte[] readPref() throws IOException {
        try {
            String keysetHex = this.sharedPreferences.getString(this.keysetName, null);
            if (keysetHex == null) {
                throw new IOException(String.format("can't read keyset; the pref value %s does not exist", this.keysetName));
            }
            return Hex.decode(keysetHex);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new IOException(String.format("can't read keyset; the pref value %s is not a valid hex string", this.keysetName), e);
        }
    }

    @Override
    public Keyset read() throws IOException {
        return Keyset.parseFrom(this.readPref());
    }

    @Override
    public EncryptedKeyset readEncrypted() throws IOException {
        return EncryptedKeyset.parseFrom(this.readPref());
    }
}

