/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.aead.KmsEnvelopeAead;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KmsEnvelopeAeadKey;
import com.google.crypto.tink.proto.KmsEnvelopeAeadKeyFormat;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class KmsEnvelopeAeadKeyManager
implements KeyManager<Aead> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.KmsEnvelopeAeadKey";

    KmsEnvelopeAeadKeyManager() {
    }

    @Override
    public Aead getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            KmsEnvelopeAeadKey keyProto = KmsEnvelopeAeadKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized KmSEnvelopeAeadKey proto", e);
        }
    }

    @Override
    public Aead getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof KmsEnvelopeAeadKey)) {
            throw new GeneralSecurityException("expected KmsEnvelopeAeadKey proto");
        }
        KmsEnvelopeAeadKey keyProto = (KmsEnvelopeAeadKey)key;
        this.validate(keyProto);
        String keyUri = keyProto.getParams().getKekUri();
        KmsClient kmsClient = KmsClients.get(keyUri);
        Aead remote = kmsClient.getAead(keyUri);
        return new KmsEnvelopeAead(keyProto.getParams().getDekTemplate(), remote);
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            KmsEnvelopeAeadKeyFormat format = KmsEnvelopeAeadKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)format);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized KmsEnvelopeAeadKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof KmsEnvelopeAeadKeyFormat)) {
            throw new GeneralSecurityException("expected KmsEnvelopeAeadKeyFormat proto");
        }
        KmsEnvelopeAeadKeyFormat format = (KmsEnvelopeAeadKeyFormat)keyFormat;
        return KmsEnvelopeAeadKey.newBuilder().setParams(format).setVersion(0).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        KmsEnvelopeAeadKey key = (KmsEnvelopeAeadKey)this.newKey(serializedKeyFormat);
        return (KeyData)KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.REMOTE).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return typeUrl.equals(TYPE_URL);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(KmsEnvelopeAeadKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
    }
}

